/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.utils;

import com.google.common.collect.ComputationException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyPair;
import javax.crypto.Cipher;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jetbrains.annotations.NotNull;

public final class CryptoUtils {
    private static final JcaPEMKeyConverter JCA_PEM_KEY_CONVERTER = new JcaPEMKeyConverter().setProvider("BC");

    private CryptoUtils() {
    }

    @NotNull
    public static PEMKeyPair parsePemKeyPair(@NotNull File keyPairFile) throws IOException {
        FileReader br = new FileReader(keyPairFile);
        try (PEMParser pemParser = new PEMParser((Reader)br);){
            Object object = pemParser.readObject();
            if (object instanceof PEMKeyPair) {
                PEMKeyPair pEMKeyPair = (PEMKeyPair)object;
                return pEMKeyPair;
            }
            throw new IllegalArgumentException("Don't know how to handle " + keyPairFile.getAbsolutePath() + " of type " + object.getClass().getCanonicalName());
        }
    }

    public static Cipher getCipherForKey(File keyLocation, String cipherSpec) {
        try {
            PEMKeyPair pemKeyPair = CryptoUtils.parsePemKeyPair(keyLocation);
            KeyPair privateKey = CryptoUtils.toJavaKeyPair(pemKeyPair);
            Cipher cipher = Cipher.getInstance(cipherSpec);
            cipher.init(2, privateKey.getPrivate());
            return cipher;
        }
        catch (Exception e) {
            throw new ComputationException((Throwable)e);
        }
    }

    private static KeyPair toJavaKeyPair(PEMKeyPair keyPair) throws PEMException {
        return JCA_PEM_KEY_CONVERTER.getKeyPair(keyPair);
    }
}

