/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.amq;

import com.atlassian.bamboo.setup.ServerFingerprint;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class AgentJmsUtils {
    private static final Logger log = Logger.getLogger(AgentJmsUtils.class);
    private static final String JMS_PROPERTY_UUID_HASH = "BambooUuidHash";
    private static final String JMS_PROPERTY_EXPENSIVE = "BambooExpensive";
    private static final String VIRTUAL_TOPIC_PREFIX = "VirtualTopic.";

    private AgentJmsUtils() {
    }

    @Nullable
    public static Integer getUuidHash(Message message) {
        try {
            return message.getIntProperty(JMS_PROPERTY_UUID_HASH);
        }
        catch (JMSException e) {
            log.warn((Object)"An exception occurred when accessing JMS message property", (Throwable)e);
            return null;
        }
    }

    public static void setUuidHash(Message message, int uuidHash) {
        try {
            message.setIntProperty(JMS_PROPERTY_UUID_HASH, uuidHash);
        }
        catch (JMSException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setExpensive(Message message, boolean expensive) {
        try {
            if (expensive) {
                message.setBooleanProperty(JMS_PROPERTY_EXPENSIVE, true);
            } else if (message.propertyExists(JMS_PROPERTY_EXPENSIVE)) {
                message.setBooleanProperty(JMS_PROPERTY_EXPENSIVE, false);
            }
        }
        catch (JMSException e) {
            log.warn((Object)"An exception occurred when accessing JMS message property", (Throwable)e);
        }
    }

    public static boolean isExpensive(Message message) {
        try {
            return message.propertyExists(JMS_PROPERTY_EXPENSIVE) && message.getBooleanProperty(JMS_PROPERTY_EXPENSIVE);
        }
        catch (JMSException e) {
            log.warn((Object)"An exception occurred when accessing JMS message property", (Throwable)e);
            return false;
        }
    }

    private static String getTopicName(Topic topic) {
        try {
            return topic.getTopicName();
        }
        catch (JMSException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean isVirtualTopic(Topic topic) {
        return topic instanceof ActiveMQTopic && AgentJmsUtils.getTopicName(topic).startsWith(VIRTUAL_TOPIC_PREFIX);
    }

    public static String getDestinationName(Topic topic, String id) {
        String topicName = AgentJmsUtils.getTopicName(topic);
        return AgentJmsUtils.isVirtualTopic(topic) ? "Consumer." + id + "." + topicName : topicName;
    }

    @Nullable
    public static Long getInstanceFingerprint(Message message) throws JMSException {
        return AgentJmsUtils.getLongProperty(message, "instanceFingerprint");
    }

    private static void setInstanceFingerprint(Message message, long value) throws JMSException {
        message.setLongProperty("instanceFingerprint", value);
    }

    @Nullable
    private static Long getLongProperty(Message message, String propertyName) throws JMSException {
        return message.propertyExists(propertyName) ? Long.valueOf(message.getLongProperty(propertyName)) : null;
    }

    public static void setFingerprint(Message message, ServerFingerprint fingerprint) throws JMSException {
        message.setStringProperty("fingerprint", fingerprint.getServerFingerprint());
        AgentJmsUtils.setInstanceFingerprint(message, fingerprint.getInstanceFingerprint());
    }
}

