/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.amq;

import com.atlassian.bamboo.beehive.BambooClusterNodeHeartbeatService;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.activemq.broker.AbstractLocker;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.util.ServiceStopper;
import org.apache.log4j.Logger;

public class BambooAmqClusterLocker
extends AbstractLocker
implements Locker {
    private static final Logger log = Logger.getLogger(BambooAmqClusterLocker.class);
    @Inject
    private BambooClusterNodeHeartbeatService bambooClusterNodeService;

    public void configure(PersistenceAdapter persistenceAdapter) throws IOException {
    }

    protected void doStop(ServiceStopper serviceStopper) {
        log.info((Object)"Bamboo amq cluster locker stopped");
    }

    protected void doStart() throws Exception {
        log.info((Object)"Bamboo amq cluster locker started");
        boolean locked = false;
        boolean warned = false;
        while (!(this.isStopped() || this.isStopping() || locked)) {
            locked = this.shouldStart();
            if (!locked && !warned) {
                log.warn((Object)"ActiveMQ persistence lock is held by another server. This broker is now in slave mode waiting a lock to be acquired.");
                warned = true;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(this.lockAcquireSleepInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!locked) {
            throw new IOException("attempt to obtain lock aborted due to shutdown");
        }
    }

    private boolean shouldStart() {
        return this.bambooClusterNodeService.isCurrentNodePrimaryBuffered();
    }
}

