/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.amq;

import com.atlassian.bamboo.amq.ExitOnShutdownIOExceptionHandler;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.security.JmsSslManagementUtils;
import com.atlassian.bamboo.security.KeyStoreFactory;
import com.atlassian.bamboo.setup.BambooSharedProperties;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.config.ConfigurationException;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooBrokerService {
    private static final boolean IS_JMS_TUNNEL_ENABLED = SystemProperty.EC2_JMS_TUNNEL_ENABLED.getTypedValue();
    private static final Logger log = LogManager.getLogger(BambooBrokerService.class);
    private static final String SCHEME_TCP = "tcp";
    private static final String SCHEME_SSL = "ssl";
    private static final List<String> SSL_SCHEMES = Arrays.asList("ssl", "nio+ssl");
    private static final int PORT_OFFSET_SSL = 1;
    private static final int PORT_OFFSET_TUNNEL = 2;
    private final BrokerService brokerService;
    private BootstrapManager bootstrapManager;
    private KeyStoreFactory keyStoreFactory;
    private SecretEncryptionService secretEncryptionService;
    private final ResettableLazyReference<String> keyStorePassword = new ResettableLazyReference<String>(){

        protected String create() throws Exception {
            String maybeEncrypted = BambooBrokerService.this.bootstrapManager.getBambooSharedProperties().getJmsKeyStorePasswordEncrypted();
            if (StringUtils.isBlank((CharSequence)maybeEncrypted)) {
                return BambooBrokerService.this.createNewPassword();
            }
            if (BambooBrokerService.this.secretEncryptionService.isEncrypted(maybeEncrypted)) {
                return BambooBrokerService.this.secretEncryptionService.decrypt(maybeEncrypted);
            }
            return maybeEncrypted;
        }
    };
    private final ResettableLazyReference<KeyStore> keyStore = new ResettableLazyReference<KeyStore>(){

        protected KeyStore create() throws Exception {
            try {
                if (StringUtils.isBlank((CharSequence)SystemProperty.BAMBOO_JMS_SSL_KEYSTORE.getValue())) {
                    return JmsSslManagementUtils.getBrokerKeyStore(BambooBrokerService.this.keyStoreFactory, ((String)BambooBrokerService.this.keyStorePassword.get()).toCharArray());
                }
                return JmsSslManagementUtils.getBrokerKeyStore(BambooBrokerService.this.keyStoreFactory);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access key store", e);
            }
        }
    };
    private volatile URI endpointForJmsTunnel;

    @NotNull
    private String createNewPassword() {
        log.info("Creating new JMS keystore password");
        String newPassword = RandomStringUtils.randomAlphanumeric((int)16, (int)20);
        if (!this.bootstrapManager.isSetupComplete()) {
            log.info("Temporarily storing the unencrypted JMS keystore password in the configuration file. It will be encrypted when the setup finishes");
            this.savePassword(newPassword);
        } else {
            String newEncrypted = this.secretEncryptionService.encrypt(newPassword);
            this.savePassword(newEncrypted);
        }
        return newPassword;
    }

    private void savePassword(String password) {
        try {
            this.bootstrapManager.getBambooSharedProperties().createNewJmsKeyStorePassword(password);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException("Unable to create new keystore password", e);
        }
    }

    @Inject
    public BambooBrokerService(BrokerService brokerService, BootstrapManager bootstrapManager, KeyStoreFactory keyStoreFactory, SecretEncryptionService secretEncryptionService) {
        this.brokerService = brokerService;
        this.bootstrapManager = bootstrapManager;
        this.keyStoreFactory = keyStoreFactory;
        this.secretEncryptionService = secretEncryptionService;
    }

    @PostConstruct
    private void modifyInitialBrokerSettings() {
        log.info("Setting up JMS SSL");
        if (JmsSslManagementUtils.isJmsKeystoreAutomaticManagementDisabled() || this.brokerService.getSslContext() != null) {
            log.info("Automatic JMS SSL management disabled");
            return;
        }
        try {
            String password = StringUtils.isEmpty((CharSequence)SystemProperty.BAMBOO_JMS_SSL_KEYSTORE_PASSWORD.getValue()) ? (String)this.keyStorePassword.get() : JmsSslManagementUtils.decodePassword(SystemProperty.BAMBOO_JMS_SSL_KEYSTORE_PASSWORD.getValue());
            SslContext sslContext = JmsSslManagementUtils.newSslContext((KeyStore)this.keyStore.get(), password.toCharArray());
            this.brokerService.setSslContext(sslContext);
        }
        catch (Exception e) {
            log.info("Cannot enable SSL on broker:", (Throwable)e);
        }
        log.debug("Setting up broker memory usage limit");
        this.brokerService.getSystemUsage().getMemoryUsage().setLimit(SystemProperty.BAMBOO_ACTIVE_MQ_MEMORY_USAGE_LIMIT_MB.getTypedValue() * 1024L * 1024L);
        this.brokerService.setIoExceptionHandler((IOExceptionHandler)new ExitOnShutdownIOExceptionHandler());
        this.brokerService.setSystemExitOnShutdownExitCode(1);
    }

    @Nullable
    public Certificate getCertificate() throws KeyStoreException {
        if (JmsSslManagementUtils.isJmsKeystoreAutomaticManagementDisabled()) {
            return null;
        }
        return JmsSslManagementUtils.getBrokerCertificate((KeyStore)this.keyStore.get());
    }

    public void addStartedConnectors(URI primaryBindAddress) throws Exception {
        log.info("Starting the primary JMS connector...");
        this.startConnector(primaryBindAddress);
        if (IS_JMS_TUNNEL_ENABLED) {
            URI bindAddressForJmsTunnel = BambooBrokerService.getBindAddressForTunnelEndpoint(primaryBindAddress);
            if (!bindAddressForJmsTunnel.equals(primaryBindAddress)) {
                log.info("Starting the Elastic Agents JMS connector...");
                this.startConnector(bindAddressForJmsTunnel);
            }
            this.endpointForJmsTunnel = bindAddressForJmsTunnel;
        }
        if (SystemProperty.ENABLE_JMS_SSL_ENDPOINT.getTypedValue()) {
            URI bindAddressForEncryptedEndpoint = BambooBrokerService.getBindAddressForEncryptedEndpoint(primaryBindAddress);
            String scheme = primaryBindAddress.getScheme();
            if (!bindAddressForEncryptedEndpoint.equals(primaryBindAddress) && !SCHEME_SSL.contains(scheme)) {
                log.info("Starting the SSL JMS connector...");
                this.startConnector(bindAddressForEncryptedEndpoint);
            }
        }
    }

    private void startConnector(URI bindAddress) {
        try {
            TransportConnector transportConnector = this.brokerService.addConnector(bindAddress);
            transportConnector.setBrokerService(this.brokerService);
            if (SystemProperty.REMOTE_AGENT_ASYNCH_DISPATCH_THREADPOOL_SIZE.getTypedValue() > 0L) {
                TaskRunnerFactory taskRunnerFactory = new TaskRunnerFactory("Active MQ Task Runner for " + bindAddress, 5, true, 1000, false, (int)SystemProperty.REMOTE_AGENT_ASYNCH_DISPATCH_THREADPOOL_SIZE.getTypedValue());
                taskRunnerFactory.init();
                transportConnector.setTaskRunnerFactory(taskRunnerFactory);
            }
            transportConnector.start();
        }
        catch (Exception e) {
            log.error("Unable to start JMS connector at " + bindAddress, (Throwable)e);
        }
    }

    @NotNull
    static URI getBindAddressForTunnelEndpoint(@NotNull URI primaryBindAddress) throws URISyntaxException {
        String scheme = primaryBindAddress.getScheme();
        if (scheme.equals(SCHEME_TCP)) {
            return primaryBindAddress;
        }
        URIBuilder addressForJmsTunnel = new URIBuilder(primaryBindAddress);
        addressForJmsTunnel.setScheme(SCHEME_TCP);
        addressForJmsTunnel.setHost(InetAddress.getLoopbackAddress().getHostAddress());
        int primaryPort = addressForJmsTunnel.getPort();
        addressForJmsTunnel.setPort(primaryPort + 2);
        return addressForJmsTunnel.build();
    }

    @NotNull
    static URI getBindAddressForEncryptedEndpoint(URI primaryBindAddress) throws URISyntaxException {
        String scheme = primaryBindAddress.getScheme();
        if (!SSL_SCHEMES.contains(scheme)) {
            URIBuilder encryptedBindAddressBuilder = new URIBuilder(primaryBindAddress);
            encryptedBindAddressBuilder.setScheme(SCHEME_SSL);
            int primaryPort = encryptedBindAddressBuilder.getPort();
            encryptedBindAddressBuilder.setPort(primaryPort + 1);
            return encryptedBindAddressBuilder.build();
        }
        return primaryBindAddress;
    }

    public void removeAllConnectors() throws Exception {
        for (TransportConnector connector : this.brokerService.getTransportConnectors()) {
            try {
                connector.stop();
            }
            catch (Exception e) {
                log.warn("Error when stopping connector: ", (Throwable)e);
            }
        }
        this.brokerService.setTransportConnectors(Collections.emptyList());
        this.endpointForJmsTunnel = null;
    }

    @NotNull
    public URI getEndpointForJmsTunnel() {
        Preconditions.checkState((this.endpointForJmsTunnel != null ? 1 : 0) != 0, (Object)"JMS endpoints have been shut down");
        Preconditions.checkState((boolean)IS_JMS_TUNNEL_ENABLED, (Object)"JMS tunnelling disabled");
        return this.endpointForJmsTunnel;
    }

    public SystemUsage getSystemUsage() {
        return this.brokerService.getSystemUsage();
    }

    public List<TransportConnector> getTransportConnectors() {
        return this.brokerService.getTransportConnectors();
    }

    @Deprecated
    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public void encryptBrokerKeystorePassword() {
        log.debug("Verifying Bamboo JMS keystore password is encrypted");
        BambooSharedProperties sharedProperties = this.bootstrapManager.getBambooSharedProperties();
        String password = sharedProperties.getJmsKeyStorePasswordEncrypted();
        if (StringUtils.isBlank((CharSequence)password)) {
            log.debug("Bamboo JMS keystore password not found");
            return;
        }
        if (!this.secretEncryptionService.isEncrypted(password)) {
            log.info("Encrypting Bamboo JMS keystore password...");
            this.encryptPassword(sharedProperties, password);
            this.keyStorePassword.reset();
            this.keyStore.reset();
            log.info("Bamboo JMS keystore password encrypted.");
        }
    }

    private void encryptPassword(BambooSharedProperties sharedProperties, String password) {
        try {
            String encryptedPassword = this.secretEncryptionService.encrypt(password);
            sharedProperties.createNewJmsKeyStorePassword(encryptedPassword);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Failed to encrypt JMS keystore password", e);
        }
    }

    public void start() throws Exception {
        this.brokerService.start();
    }
}

