/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.StopBuildManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.BuildLoggerWithoutLogAccess;
import com.atlassian.bamboo.build.monitoring.BuildStopDelayedJob;
import com.atlassian.bamboo.build.monitoring.DeploymentStopDelayedJob;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.deployments.DeploymentResultKey;
import com.atlassian.bamboo.deployments.runtime.DeploymentsInProgressService;
import com.atlassian.bamboo.event.BuildCanceledEvent;
import com.atlassian.bamboo.event.VerifyAgentBuildingStatusEvent;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.bamboo.v2.build.BuildCancelledDetails;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.AgentBuildingStatus;
import com.atlassian.bamboo.v2.build.agent.AgentCommandSender;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.v2.build.agent.messages.CancelExecutionAgentMessage;
import com.atlassian.bamboo.v2.build.agent.messages.StopAgentNicelyMessage;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.v2.build.queue.QueueManagerUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class DefaultStopBuildManager
implements StopBuildManager {
    private static final Logger log = Logger.getLogger(DefaultStopBuildManager.class);
    private PlanExecutionManager planExecutionManager;
    @Lazy
    @Autowired
    private AgentManager agentManager;
    private BuildQueueManager buildQueueManager;
    private AgentCommandSender agentCommandSender;
    private EventPublisher eventPublisher;
    private Scheduler scheduler;
    private BuildLoggerManager buildLoggerManager;
    private BambooAuthenticationContext authenticationContext;
    @Autowired
    private DeploymentsInProgressService deploymentsInProgressService;

    @PostConstruct
    private void postConstruct() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    private void preDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    public void cancelAllBuilds(@NotNull PlanKey planKey, boolean abandonResult) {
        List buildingList = this.planExecutionManager.getCurrentlyBuildingForPlan(planKey);
        if (!buildingList.isEmpty()) {
            ArrayList<CurrentlyBuilding> prepareForRemoveFromQueue = new ArrayList<CurrentlyBuilding>();
            for (CurrentlyBuilding currentlyBuilding : buildingList) {
                currentlyBuilding.setBuildCancelledDetails(new BuildCancelledDetails(new Date()));
                Long buildAgentId = currentlyBuilding.getBuildAgentId();
                if (buildAgentId != null) {
                    this.stopBuildOnAgent(currentlyBuilding, buildAgentId);
                    continue;
                }
                prepareForRemoveFromQueue.add(currentlyBuilding);
            }
            QueueManagerUtils.removeFromQueue((BuildQueueManager)this.buildQueueManager, (Key)planKey);
        }
    }

    public void cancelBuild(@NotNull PlanResultKey planResultKey, boolean abandonResult) {
        List buildingList = this.planExecutionManager.getCurrentlyBuildingForPlanResult(planResultKey);
        if (buildingList.isEmpty()) {
            log.info((Object)("Trying to stop " + planResultKey + " but not building in planExecutionManager"));
            return;
        }
        for (CurrentlyBuilding building : buildingList) {
            building.setBuildCancelledDetails(new BuildCancelledDetails(new Date()));
            Long buildAgentId = building.getBuildAgentId();
            BuildCanceledEvent buildCanceledEvent = new BuildCanceledEvent((Object)this, building);
            BuildLogger planLogger = this.buildLoggerManager.getLogger((Key)planResultKey.getPlanKey());
            BuildLoggerWithoutLogAccess buildLogger = this.buildLoggerManager.getLoggerWithoutLogAccess((Key)planResultKey);
            CommandLogEntry commandLogEntry = new CommandLogEntry(String.format("Request to %s '%s' received from %s", abandonResult ? "abandon" : "stop", planResultKey, this.authenticationContext.getUserName()));
            log.info((Object)planLogger.addBuildLogEntry((LogEntry)commandLogEntry));
            buildLogger.addBuildLogEntry((LogEntry)commandLogEntry);
            if (buildAgentId != null) {
                this.stopBuildOnAgent(building, buildAgentId);
            } else {
                this.buildQueueManager.removeBuildFromQueue((ResultKey)planResultKey);
            }
            this.eventPublisher.publish((Object)buildCanceledEvent);
        }
    }

    @EventListener
    public void onVerifyAgentBuildingStatus(@NotNull VerifyAgentBuildingStatusEvent event) {
        AgentBuildingStatus agentBuildingStatus = event.getAgentBuildingStatus();
        ResultKey resultKey = agentBuildingStatus.getResultKey();
        PlanResultKey planResultKey = (PlanResultKey)Narrow.downTo((Object)resultKey, PlanResultKey.class);
        if (planResultKey != null) {
            List buildingList = this.planExecutionManager.getCurrentlyBuildingForPlanResult(planResultKey);
            if (buildingList.isEmpty()) {
                log.info((Object)String.format("Agent [%s, %s] reported that it is building %s but no record of this build in CBC. Requesting agent to stop it...", event.getAgentName(), event.getAgentId(), planResultKey));
                this.stopBuildOnAgent(planResultKey, (Long)event.getAgentId());
            }
            return;
        }
        DeploymentResultKey deploymentResultKey = (DeploymentResultKey)Narrow.downTo((Object)resultKey, DeploymentResultKey.class);
        if (deploymentResultKey != null && this.deploymentsInProgressService.getDeploymentInProgressById(deploymentResultKey.getDeploymentResultId()) == null) {
            log.info((Object)String.format("Agent [%s, %s] reported that it is deploying %s but no record of this deployment on the server. Requesting agent to stop it...", event.getAgentName(), event.getAgentId(), deploymentResultKey));
            this.stopExecutionOnAgent((ResultKey)deploymentResultKey, deploymentResultKey.getDeploymentResultId(), event.getAgentId());
        }
    }

    private void stopExecutionOnAgent(final @NotNull ResultKey resultKey, final @Nullable Long deploymentResultId, final Long agentId) {
        XsrfUtils.assertCanPerformMutativeAction((String)"Stop executing process on agent: unable to perform mutative operation");
        BuildAgent buildAgent = this.agentManager.getAgent(agentId.longValue());
        if (buildAgent != null) {
            buildAgent.accept(new BuildAgent.BuildAgentVisitor(){

                public void visitLocal(LocalBuildAgent localBuildAgent) {
                    localBuildAgent.getExecutableBuildAgent().cancelBuild(resultKey.getKey());
                }

                public void visitRemote(BuildAgent remoteBuildAgent) {
                    DefaultStopBuildManager.this.agentCommandSender.send(new CancelExecutionAgentMessage(resultKey, deploymentResultId), agentId);
                }
            });
        }
    }

    public void cancelDeployment(@NotNull ResultKey resultKey, @NotNull Long deploymentResultId, @Nullable Long agentId) {
        BuildLoggerWithoutLogAccess logger = this.buildLoggerManager.getLoggerWithoutLogAccess((Key)resultKey);
        CommandLogEntry commandLogEntry = new CommandLogEntry(String.format("Request to stop '%s' received from %s", resultKey, this.authenticationContext.getUserName()));
        log.info((Object)logger.addBuildLogEntry((LogEntry)commandLogEntry));
        if (agentId == null) {
            this.buildQueueManager.removeBuildFromQueue(resultKey);
        } else {
            log.info((Object)("Stopping deployment " + resultKey + " on agent " + agentId));
            this.scheduleStopDeploymentOnAgentTimer(resultKey);
            this.stopExecutionOnAgent(resultKey, deploymentResultId, agentId);
        }
    }

    private void stopBuildOnAgent(CurrentlyBuilding currentlyBuilding, Long buildAgentId) {
        this.stopBuildOnAgent(currentlyBuilding.getBuildIdentifier().getPlanResultKey(), buildAgentId);
    }

    private void stopBuildOnAgent(PlanResultKey planResultKey, Long buildAgentId) {
        log.info((Object)("Stopping build " + planResultKey + " on agent " + buildAgentId));
        this.scheduleStopBuildOnAgentTimer(planResultKey);
        this.stopExecutionOnAgent((ResultKey)planResultKey, null, buildAgentId);
    }

    private void scheduleStopDeploymentOnAgentTimer(ResultKey resultKey) {
        Class<DeploymentStopDelayedJob> jobClass = DeploymentStopDelayedJob.class;
        JobKey jobKey = new JobKey(DeploymentStopDelayedJob.getJobName((ResultKey)resultKey), DeploymentStopDelayedJob.getJobGroupName());
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobKey).build();
        jobDetail.getJobDataMap().put("resultKey", resultKey.getKey());
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobKey.getName()).startAt(DateUtils.addSeconds((Date)new Date(), (int)60)).build();
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
            log.info((Object)("Deployment " + resultKey + " will be checked for termination at " + trigger.getNextFireTime()));
        }
        catch (ObjectAlreadyExistsException ignored) {
            log.info((Object)("Job " + jobDetail + " already scheduled, not scheduling again"));
        }
        catch (SchedulerException e) {
            log.error((Object)"Unable to schedule build stop on agent monitor", (Throwable)e);
        }
    }

    private void scheduleStopBuildOnAgentTimer(PlanResultKey planResultKey) {
        Class<BuildStopDelayedJob> jobClass = BuildStopDelayedJob.class;
        JobKey jobKey = new JobKey(BuildStopDelayedJob.getJobName((PlanResultKey)planResultKey), BuildStopDelayedJob.getJobGroupName());
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobKey).build();
        jobDetail.getJobDataMap().put("buildResultKey", planResultKey.getKey());
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobKey.getName()).startAt(DateUtils.addSeconds((Date)new Date(), (int)60)).build();
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
            log.info((Object)("Build " + planResultKey + " will be checked for termination at " + trigger.getNextFireTime()));
        }
        catch (ObjectAlreadyExistsException ignored) {
            log.info((Object)("Job " + jobDetail + " already scheduled, not scheduling again"));
        }
        catch (SchedulerException e) {
            log.error((Object)"Unable to schedule build stop on agent monitor", (Throwable)e);
        }
    }

    public void stopAgentNicely(final @NotNull BuildAgent buildAgent) {
        buildAgent.accept(new BuildAgent.BuildAgentVisitor(){

            public void visitLocal(LocalBuildAgent localBuildAgent) {
                localBuildAgent.getExecutableBuildAgent().stopNicely();
            }

            public void visitRemote(BuildAgent remoteBuildAgent) {
                DefaultStopBuildManager.this.agentCommandSender.send(new StopAgentNicelyMessage(), buildAgent.getId());
            }
        });
        buildAgent.setRequestedToBeStopped(true);
    }

    public void setBuildQueueManager(BuildQueueManager buildQueueManager) {
        this.buildQueueManager = buildQueueManager;
    }

    public void setAgentCommandSender(AgentCommandSender agentCommandSender) {
        this.agentCommandSender = agentCommandSender;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setPlanExecutionManager(PlanExecutionManager planExecutionManager) {
        this.planExecutionManager = planExecutionManager;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setAuthenticationContext(BambooAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }
}

