/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.CurrentlyBuildingContainer;
import com.atlassian.bamboo.build.FlushableBuildLoggerManager;
import com.atlassian.bamboo.build.ServerBuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.BuildLoggerImpl;
import com.atlassian.bamboo.build.logger.BuildLoggerWithoutLogAccess;
import com.atlassian.bamboo.build.logger.FileWritingBuildLogger;
import com.atlassian.bamboo.build.logger.LoggerId;
import com.atlassian.bamboo.build.logger.LoggerIds;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.deployments.DeploymentResultKey;
import com.atlassian.bamboo.deployments.runtime.DeploymentInProgress;
import com.atlassian.bamboo.deployments.runtime.DeploymentsInProgressService;
import com.atlassian.bamboo.expirables.ExpiryTicker;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.serialization.ServerSideOnly;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.bamboo.utils.concurrent.DecayingBoolean;
import com.atlassian.bamboo.utils.concurrent.DecayingBooleanImpl;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.AgentCommandSender;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.v2.build.agent.messages.toagent.LogsAreWatchedAgentMessage;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

@ServerSideOnly
public class DefaultBuildLoggerManager
implements FlushableBuildLoggerManager,
ServerBuildLoggerManager {
    private static final Logger log = Logger.getLogger(DefaultBuildLoggerManager.class);
    public static final long LOG_TRANSMISSION_KEEPALIVE_SECONDS = 15L;
    @Lazy
    @Inject
    private CurrentlyBuildingContainer cbc;
    @Inject
    private AgentCommandSender agentCommandSender;
    @Lazy
    @Inject
    private AgentManager agentManager;
    @Lazy
    @Inject
    private DeploymentsInProgressService deploymentsInProgressService;
    private final ExpiryTicker expiryTicker;
    private final CacheLoader<? super LoggerId, BuildLoggerImpl> NEW_BUILD_LOGGER = new CacheLoader<LoggerId, BuildLoggerImpl>(){

        public BuildLoggerImpl load(LoggerId loggerId) {
            return new BuildLoggerImpl(loggerId, DefaultBuildLoggerManager.this.expiryTicker);
        }
    };
    private final LoadingCache<LoggerId, BuildLoggerImpl> BUILD_LOGGERS = CacheBuilder.newBuilder().softValues().build(this.NEW_BUILD_LOGGER);
    private final LoadingCache<ResultKey, DecayingBoolean> shouldRemindAgentToSendLogs = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ResultKey, DecayingBoolean>(){

        public DecayingBoolean load(@NotNull ResultKey key) {
            return new DecayingBooleanImpl(false, Duration.ofSeconds(15L));
        }
    });

    public DefaultBuildLoggerManager(@NotNull ExpiryTicker expiryTicker) {
        this.expiryTicker = expiryTicker;
    }

    @NotNull
    public BuildLogger getLogger(@NotNull Key key) {
        ResultKey resultKey = (ResultKey)Narrow.downTo((Object)key, ResultKey.class);
        if (resultKey != null) {
            return this.getLogger(resultKey);
        }
        return (BuildLogger)this.BUILD_LOGGERS.getUnchecked((Object)LoggerIds.get((Key)key));
    }

    @NotNull
    public BuildLogger getLogger(final @NotNull ResultKey resultKey) {
        Long agentId;
        BuildLogger buildLogger = (BuildLogger)this.BUILD_LOGGERS.getUnchecked((Object)LoggerIds.get((ResultKey)resultKey));
        if (!buildLogger.isPersistent() && (agentId = this.findAgentIdForResultKey(resultKey)) != null) {
            BuildAgent buildAgent = this.agentManager.getAgent(agentId.longValue());
            if (buildAgent != null) {
                buildAgent.accept(new BuildAgent.BuildAgentVisitor(){

                    public void visitLocal(LocalBuildAgent localBuildAgent) {
                        log.debug((Object)"Build is running on a local agent. Log keepalive message won't be sent");
                    }

                    public void visitRemote(BuildAgent remoteBuildAgent) {
                        DecayingBoolean shouldSendToAgent = (DecayingBoolean)DefaultBuildLoggerManager.this.shouldRemindAgentToSendLogs.getUnchecked((Object)resultKey);
                        if (shouldSendToAgent.compareAndSet(false, true)) {
                            log.debug((Object)("Sending log keepalive to agent " + agentId));
                            DefaultBuildLoggerManager.this.agentCommandSender.send(new LogsAreWatchedAgentMessage(resultKey), agentId);
                        }
                    }
                });
            } else {
                log.warn((Object)String.format("Can't find agent with id %d. Log keepalive won't be sent", agentId));
            }
        }
        return buildLogger;
    }

    @Nullable
    private Long findAgentIdForResultKey(@NotNull ResultKey resultKey) {
        if (resultKey instanceof PlanResultKey) {
            CurrentlyBuilding currentlyBuilding = this.cbc.getCurrentlyBuildingByResultKey(resultKey);
            if (currentlyBuilding != null) {
                return currentlyBuilding.getBuildAgentId();
            }
        } else {
            DeploymentInProgress deploymentInProgress;
            DeploymentResultKey deploymentResultKey = (DeploymentResultKey)Narrow.downTo((Object)resultKey, DeploymentResultKey.class);
            if (deploymentResultKey != null && (deploymentInProgress = this.deploymentsInProgressService.getDeploymentInProgressById(deploymentResultKey.getDeploymentResultId())) != null) {
                return deploymentInProgress.getAgentId();
            }
        }
        return null;
    }

    public FileWritingBuildLogger getPersistentLogger(@NotNull ResultKey resultKey) {
        LoggerId loggerId = LoggerIds.get((ResultKey)resultKey);
        return this.getFileWritingLogger((LoggerId<? extends Key>)loggerId, true);
    }

    @NotNull
    public FileWritingBuildLogger getNonPersistentLogger(@NotNull ResultKey resultKey) {
        LoggerId loggerId = LoggerIds.get((ResultKey)resultKey);
        return this.getFileWritingLogger((LoggerId<? extends Key>)loggerId, false);
    }

    @NotNull
    public FileWritingBuildLogger getFileWritingLogger(@NotNull LoggerId<? extends Key> loggerId) {
        return this.getFileWritingLogger(loggerId, loggerId.isPersistent());
    }

    private FileWritingBuildLogger getFileWritingLogger(@NotNull LoggerId<? extends Key> loggerId, boolean persistent) {
        BuildLoggerImpl buildLogger = (BuildLoggerImpl)this.BUILD_LOGGERS.getIfPresent(loggerId);
        if (buildLogger != null) {
            buildLogger.switchPersistence(persistent);
        }
        return (FileWritingBuildLogger)this.BUILD_LOGGERS.getUnchecked(loggerId);
    }

    @NotNull
    public BuildLoggerWithoutLogAccess getLoggerWithoutLogAccess(@NotNull Key key) {
        return this.getLoggerWithoutLogAccess(LoggerIds.get((Key)key));
    }

    @NotNull
    public <T extends Key> BuildLoggerWithoutLogAccess getLoggerWithoutLogAccess(@NotNull LoggerId<T> loggerId) {
        return (BuildLoggerWithoutLogAccess)this.BUILD_LOGGERS.getUnchecked(loggerId);
    }

    public void removeBuildLogger(PlanKey planKey) {
        this.removeLogger(LoggerIds.get((Key)planKey));
    }

    public void removeBuildLogger(PlanResultKey buildResultKey) {
        this.removeLogger(LoggerIds.get((ResultKey)buildResultKey));
    }

    public <T extends Key> void removeLogger(LoggerId<T> loggerId) {
        this.BUILD_LOGGERS.invalidate(loggerId);
    }

    public void removeLogger(@NotNull ResultKey resultKey) {
        this.removeLogger(LoggerIds.get((ResultKey)resultKey));
    }

    public void transferLogs(BuildLogger buildLogger, CommonContext commonContext) {
    }

    @NotNull
    public Future<?> flushAllFileLogs() {
        return Executors.newSingleThreadExecutor().submit(() -> this.BUILD_LOGGERS.asMap().values().stream().flatMap(OptionalNarrow.down(BuildLoggerImpl.class)).forEach(BuildLoggerImpl::flush));
    }
}

