/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.ephemeral.EphemeralAgentTemplate;
import com.atlassian.bamboo.agent.ephemeral.logging.EphemeralAgentManagementLogger;
import com.atlassian.bamboo.amq.BambooBrokerService;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.EphemeralAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemotableRemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.dao.ElasticTunnelDefinitionDao;
import com.atlassian.bamboo.buildqueue.manager.AgentHeartBeatInfo;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentAuthenticationManager;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentManager;
import com.atlassian.bamboo.buildqueue.properties.DistributedProperties;
import com.atlassian.bamboo.cluster.state.DelayedStateInitialization;
import com.atlassian.bamboo.cluster.state.DelayedStateInitializationBag;
import com.atlassian.bamboo.cluster.state.Stateful;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.StartupStatisticsBean;
import com.atlassian.bamboo.configuration.SystemInfo;
import com.atlassian.bamboo.core.ScopedExclusionServiceImpl;
import com.atlassian.bamboo.event.AgentConfigurationUpdatedEvent;
import com.atlassian.bamboo.event.VerifyAgentBuildingStatusEvent;
import com.atlassian.bamboo.event.agent.AgentRegisteredEvent;
import com.atlassian.bamboo.event.agent.AgentRegisteringEvent;
import com.atlassian.bamboo.event.ephemeral.EphemeralAgentLaunchFailed;
import com.atlassian.bamboo.license.BambooLicenseException;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.agent.AgentBuildingStatus;
import com.atlassian.bamboo.v2.build.agent.AgentIdleStatus;
import com.atlassian.bamboo.v2.build.agent.AgentOfflineStatus;
import com.atlassian.bamboo.v2.build.agent.AgentStatus;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.BuildAgentImpl;
import com.atlassian.bamboo.v2.build.agent.EphemeralNotExistAnymoreException;
import com.atlassian.bamboo.v2.build.agent.RemotableRemoteAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySource;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.text.DateFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections4.SetUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Stateful
public class RemoteAgentManagerImpl
implements RemoteAgentManager,
DelayedStateInitialization {
    private static final Logger log = LogManager.getLogger(RemoteAgentManagerImpl.class);
    private static final int REMOTE_AGENT_LOG_SIZE = 15;
    private static final long GRACE_PERIOD_MULTIPLIER = 2L;
    private static final boolean DISABLE_AGENT_UPDATE_CAPABILITIES_ON_START = SystemProperty.DISABLE_AGENT_CAPABILITY_UPDATE.getTypedValue();
    static final Pattern SPLIT_NAME_AND_NUMBER = Pattern.compile("(.*) \\((\\d*)\\)$");
    private static final int MAX_HEARTBEAT_COUNT_BETWEEN_BUILD_STATUS_VERIFICATION = 100;
    private final LinkedList<String> remoteAgentLog = new LinkedList();
    private volatile long lastCheckOfflineAgentsTimestamp = System.currentTimeMillis();
    private final AtomicBoolean checkOfflineAgentsRunning = new AtomicBoolean(false);
    private static final String UNKNOWN_PLACEHOLDER = "UNKNOWN";
    @Inject
    private AgentManager agentManager;
    @Inject
    private BambooBrokerService brokerService;
    @Inject
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    @Inject
    private Persister persister;
    @Inject
    private RemoteAgentAuthenticationManager remoteAgentAuthenticationManager;
    @Inject
    private ElasticTunnelDefinitionDao elasticTunnelDefinitionDao;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private EphemeralAgentManagementLogger ephemeralAgentManagementLogger;
    private URI baseBrokerUri;
    private int heartbeatCheckInterval;
    private int heartbeatInterval;
    private final int heartbeatTimeoutSeconds;
    private final EventPublisher eventPublisher;
    private final Long startupTimestamp;
    private volatile Date connectorsStartDate;
    private final LoadingCache<Long, ReadWriteLock> returningAgentProcessingLocks = ScopedExclusionServiceImpl.weakReadWriteLockFactory();

    public RemoteAgentManagerImpl(int heartbeatTimeoutSeconds, StartupStatisticsBean startupStatisticsBean, EventPublisher eventPublisher) {
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
        this.eventPublisher = eventPublisher;
        log.info("Heartbeat timeout for remote agents: " + heartbeatTimeoutSeconds + " seconds.");
        this.startupTimestamp = startupStatisticsBean.getStartupTimestamp();
        DelayedStateInitializationBag.register((DelayedStateInitialization)this);
    }

    public void init() {
        this.lastCheckOfflineAgentsTimestamp = System.currentTimeMillis();
    }

    @NotNull
    public RemotableRemoteAgentDefinition registerAgent(@NotNull RemotableRemoteAgentDefinition remotableRemoteAgentDefinition) {
        PipelineDefinition pipelineDefinition = this.registerAgent(remotableRemoteAgentDefinition.createPipelineDefinition());
        return new RemotableRemoteAgentDefinitionImpl(pipelineDefinition);
    }

    @NotNull
    public PipelineDefinition registerAgent(@NotNull PipelineDefinition remoteAgentDefinition) throws BambooLicenseException {
        this.eventPublisher.publish((Object)new AgentRegisteringEvent((Object)this, remoteAgentDefinition));
        try {
            if (remoteAgentDefinition.getId() != -1L) {
                Lock lock = ((ReadWriteLock)this.returningAgentProcessingLocks.getUnchecked((Object)remoteAgentDefinition.getId())).writeLock();
                lock.lock();
                try {
                    this.registerReturningAgent(remoteAgentDefinition);
                }
                finally {
                    lock.unlock();
                }
            }
            if (remoteAgentDefinition.getId() == -1L) {
                this.assertLicenseAllowsANewAgent(remoteAgentDefinition);
                this.registerNewAgent(remoteAgentDefinition);
            }
        }
        catch (RuntimeException e) {
            this.reportRegistrationError(remoteAgentDefinition, e);
            throw e;
        }
        this.eventPublisher.publish((Object)new AgentRegisteredEvent((Object)this, remoteAgentDefinition));
        return remoteAgentDefinition;
    }

    private void registerNewAgent(final PipelineDefinition remoteAgentDefinition) {
        remoteAgentDefinition.setName(this.ensureUniqueName(remoteAgentDefinition.getName()));
        remoteAgentDefinition.accept(new PipelineDefinitionVisitor(){

            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                pipelineDefinition.setLastStartupTime(new Date());
                pipelineDefinition.setLastShutdownTime(null);
                RemoteAgentManagerImpl.this.agentManager.saveElasticPipeline(pipelineDefinition);
                RemoteAgentManagerImpl.this.elasticFunctionalityFacade.persistTunnelDataOfInstance(pipelineDefinition);
                RemoteAgentManagerImpl.this.addRemoteAgentLogEntry("Elastic Agent \"" + remoteAgentDefinition.getName() + "\" has registered.");
                log.info("Elastic agent created with id " + remoteAgentDefinition.getId());
            }

            public void visitEphemeral(EphemeralAgentDefinition pipelineDefinition) {
                pipelineDefinition.setLastStartupTime(new Date());
                pipelineDefinition.setLastShutdownTime(null);
                RemoteAgentManagerImpl.this.agentManager.saveEphemeralPipeline(pipelineDefinition);
                RemoteAgentManagerImpl.this.addRemoteAgentLogEntry("Ephemeral Agent \"" + remoteAgentDefinition.getName() + "\" has registered.");
                log.info("Ephemeral agent created with id " + remoteAgentDefinition.getId());
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                log.error("Local agents cannot register as remote");
                throw new IllegalArgumentException("Local agent cannot be registered.");
            }

            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                pipelineDefinition.setLastStartupTime(new Date());
                pipelineDefinition.setLastShutdownTime(null);
                RemoteAgentManagerImpl.this.agentManager.savePipeline((PipelineDefinition)pipelineDefinition);
                RemoteAgentManagerImpl.this.addRemoteAgentLogEntry("Remote agent \"" + remoteAgentDefinition.getName() + "\" has registered.");
                log.info("Remote agent created with id " + remoteAgentDefinition.getId());
            }
        });
    }

    private void registerReturningAgent(PipelineDefinition remoteAgentDefinition) {
        remoteAgentDefinition.accept((PipelineDefinitionVisitor)new ReturningAgentPipelineDefinitionVisitor());
    }

    private void assertLicenseAllowsANewAgent(PipelineDefinition remoteAgentDefinition) {
        remoteAgentDefinition.accept(new PipelineDefinitionVisitor(){

            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                if (!RemoteAgentManagerImpl.this.agentManager.allowNewElasticAgent()) {
                    throw new BambooLicenseException("Cannot register additional elastic agent. You have reached the limit for the number of remote agents you can have. Please upgrade your license.");
                }
            }

            public void visitEphemeral(EphemeralAgentDefinition pipelineDefinition) {
                if (!RemoteAgentManagerImpl.this.agentManager.allowNewEphemeralAgent()) {
                    RemoteAgentManagerImpl.this.eventPublisher.publish((Object)new EphemeralAgentLaunchFailed(pipelineDefinition.getEphemeralAgentDedication()));
                    throw new BambooLicenseException("Cannot register additional ephemeral agent. You have reached the limit for the number of remote agents you can have. Please upgrade your license.");
                }
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                throw new IllegalArgumentException("Local agent already has id: " + pipelineDefinition.getId() + ", and cannot be registered.");
            }

            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                if (!RemoteAgentManagerImpl.this.agentManager.allowNewRemoteAgent()) {
                    throw new BambooLicenseException("Cannot register additional remote agent. You have reached the limit for the number of remote agents you can have. Please upgrade your license.");
                }
            }
        });
    }

    private void reportRegistrationError(PipelineDefinition remoteAgentDefinition, final RuntimeException e) {
        final String message = "Registration attempt rejected with a message: " + e.getMessage();
        remoteAgentDefinition.accept(new PipelineDefinitionVisitor(){

            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                RemoteAgentManagerImpl.this.addRemoteAgentLogEntry(message);
                StringBuilder sb = new StringBuilder();
                sb.append("Registration of elastic agent at instance ");
                sb.append(pipelineDefinition.getElasticInstanceId());
                sb.append(" failed with a message: ").append(e.getMessage());
                RemoteAgentManagerImpl.this.elasticFunctionalityFacade.addElasticLogEntry(log, sb.toString());
            }

            public void visitEphemeral(EphemeralAgentDefinition pipelineDefinition) {
                RemoteAgentManagerImpl.this.addRemoteAgentLogEntry(message);
                StringBuilder sb = new StringBuilder();
                sb.append("Registration of ephemeral agent at pod ");
                sb.append(Optional.ofNullable(pipelineDefinition.getEphemeralAgentPodName()).orElse(RemoteAgentManagerImpl.UNKNOWN_PLACEHOLDER));
                sb.append(" based on template ");
                sb.append(Optional.ofNullable(pipelineDefinition.getEphemeralAgentTemplate()).map(EphemeralAgentTemplate::getConfigurationName).orElse(RemoteAgentManagerImpl.UNKNOWN_PLACEHOLDER));
                sb.append(" failed with a message: ").append(e.getMessage());
                RemoteAgentManagerImpl.this.ephemeralAgentManagementLogger.addEphemeralLogEntry(log, sb.toString(), false);
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
            }

            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                RemoteAgentManagerImpl.this.addRemoteAgentLogEntry(message);
            }
        });
    }

    public AgentHeartBeatInfo updateRemoteAgentStatus(@NotNull Long agentId, @Nullable UUID uuid, @NotNull AgentStatus newStatus, @NotNull SystemInfo systemInfo) {
        BuildAgent existingServerAgent;
        if (log.isDebugEnabled()) {
            log.debug("About to update remote agentId '" + agentId + "' with systemInfo " + systemInfo + " and status " + newStatus + ".");
        }
        if (log.isTraceEnabled()) {
            log.trace("Outputting some interesting info about the agent: ");
            log.info("getApplicationHome: " + systemInfo.getApplicationHome());
            log.info("getBuildPath: " + systemInfo.getBuildPath());
            log.info("getBuildWorkingDirectory: " + systemInfo.getBuildWorkingDirectory());
            log.info("getHostName: " + systemInfo.getHostName());
            log.info("getOperatingSystem: " + systemInfo.getOperatingSystem());
            log.info("getCurrentDate: " + systemInfo.getCurrentDate());
            log.info("uuid: " + uuid);
        }
        if ((existingServerAgent = this.agentManager.getAgent(agentId.longValue())) instanceof BuildAgentImpl) {
            Date lastRemoteTime;
            BuildAgentImpl existingRemoteAgent = (BuildAgentImpl)existingServerAgent;
            Date newRemoteTime = systemInfo.getCurrentDate();
            if (log.isDebugEnabled()) {
                long timeDelta = new Date().getTime() - newRemoteTime.getTime();
                log.debug("Updating remote agent '" + existingRemoteAgent.getName() + "' with time " + newRemoteTime + ". Delta: " + timeDelta + "ms");
            }
            if ((lastRemoteTime = existingRemoteAgent.getRemoteTimestamp()) == null || newRemoteTime.getTime() >= lastRemoteTime.getTime()) {
                AgentStatus oldStatus;
                Date newLastUpdated = new Date();
                long lastUpdatedDiffInSeconds = (newLastUpdated.getTime() - Optional.ofNullable(existingRemoteAgent.getLastUpdated()).map(Date::getTime).orElse(0L)) / 1000L;
                if ((double)lastUpdatedDiffInSeconds < 0.9 * (double)this.heartbeatInterval) {
                    log.info("Received a potentially duplicated heartbeat from agent {} '{}', the difference in last heartbeats update times is {}s", (Object)existingRemoteAgent.getId(), (Object)existingRemoteAgent.getName(), (Object)lastUpdatedDiffInSeconds);
                }
                boolean hasStateChanged = !(oldStatus = existingRemoteAgent.getAgentStatus()).equals(newStatus);
                existingRemoteAgent.setLastUpdated(newLastUpdated);
                existingRemoteAgent.setRemoteTimestamp(newRemoteTime);
                existingRemoteAgent.setSystemInfo(systemInfo);
                if (uuid != null) {
                    existingRemoteAgent.setUuid(uuid);
                }
                if (newStatus instanceof AgentBuildingStatus) {
                    int heartbeatsWhileBuildingCounter;
                    if (hasStateChanged) {
                        existingRemoteAgent.resetHeartbeatsWhileBuildingCounter();
                    }
                    if ((heartbeatsWhileBuildingCounter = existingRemoteAgent.incrementAndGetHeartbeatsWhileBuildingCounter()) > 100 || existingRemoteAgent.getAgentStatus().equals(AgentOfflineStatus.getInstance())) {
                        this.eventPublisher.publish((Object)new VerifyAgentBuildingStatusEvent(existingRemoteAgent.getId(), existingRemoteAgent.getName(), (AgentBuildingStatus)newStatus));
                        existingRemoteAgent.resetHeartbeatsWhileBuildingCounter();
                    }
                } else {
                    existingRemoteAgent.resetHeartbeatsWhileBuildingCounter();
                }
                if (hasStateChanged && newStatus.equals(AgentOfflineStatus.getInstance())) {
                    this.agentManager.stopAgent((BuildAgent)existingRemoteAgent);
                }
                existingRemoteAgent.setAgentStatus(newStatus);
                if (hasStateChanged && oldStatus.equals(AgentOfflineStatus.getInstance())) {
                    this.eventPublisher.publish((Object)new AgentConfigurationUpdatedEvent((Object)this, (BuildAgent)existingRemoteAgent));
                }
            } else {
                log.warn("Heartbeat received from remote agent '" + existingRemoteAgent.getName() + "' with time " + newRemoteTime + " but last updated time was " + lastRemoteTime + ". Status not updated...");
            }
            return new AgentHeartBeatInfo(true, this.startupTimestamp);
        }
        log.warn("Request to update remote agent status, but no remote agent with id: " + agentId + " found.");
        return new AgentHeartBeatInfo(false, this.startupTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkOfflineAgents() {
        if (this.checkOfflineAgentsRunning.compareAndSet(false, true)) {
            try {
                Stopwatch stopWatch = null;
                if (log.isDebugEnabled()) {
                    stopWatch = Stopwatch.createStarted();
                    log.debug("About to checkOfflineAgents...");
                }
                List buildAgents = this.agentManager.getAllRemoteAgents();
                long currentTime = System.currentTimeMillis();
                long gracePeriod = this.calculateGracePeriod(this.lastCheckOfflineAgentsTimestamp, currentTime, Duration.ofSeconds(this.heartbeatCheckInterval).toMillis());
                this.lastCheckOfflineAgentsTimestamp = currentTime;
                if (log.isDebugEnabled()) {
                    log.debug("Grace period of around " + Duration.ofMillis(gracePeriod).getSeconds() + "s");
                }
                for (BuildAgent buildAgent : buildAgents) {
                    if (!(buildAgent instanceof BuildAgentImpl) || buildAgent.getAgentStatus() instanceof AgentOfflineStatus) continue;
                    BuildAgentImpl remoteAgent = (BuildAgentImpl)buildAgent;
                    if (!this.isAlive(remoteAgent, gracePeriod)) {
                        log.warn("Detected that remote agent '" + remoteAgent.getName() + "' has been inactive since " + remoteAgent.getLastUpdated());
                        if (remoteAgent.isUnresponsive()) {
                            remoteAgent.setUnresponsive(false);
                            this.addRemoteAgentLogEntry(Level.WARN, "Remote agent '" + remoteAgent.getName() + "' was unresponsive and has gone offline.");
                            this.stopRemoteAgent((BuildAgent)remoteAgent);
                            continue;
                        }
                        remoteAgent.setUnresponsive(true);
                        log.warn("Marking remote agent '" + remoteAgent.getName() + "' as unresponsive");
                        continue;
                    }
                    remoteAgent.setUnresponsive(false);
                }
                if (!log.isDebugEnabled() || stopWatch == null) return;
                log.debug("Finished checkOfflineAgents took " + stopWatch);
                return;
            }
            finally {
                this.checkOfflineAgentsRunning.set(false);
            }
        } else {
            log.debug("checkOfflineAgents already running...");
        }
    }

    long calculateGracePeriod(long previouslyCheckedTime, long currentTime, long checkInterval) {
        long i = currentTime - previouslyCheckedTime - checkInterval;
        return i < 0L ? 0L : i * 2L;
    }

    public void setRemoteAgentFunctionEnabled(boolean remoteAgentFunctionEnabled) throws Exception {
        AdministrationConfiguration administrationConfiguration = this.persister.getAdministrationConfiguration();
        if (administrationConfiguration.isRemoteAgentFunctionEnabled() != remoteAgentFunctionEnabled) {
            this.startOrStopConnectors(remoteAgentFunctionEnabled);
            administrationConfiguration.setRemoteAgentFunctionEnabled(remoteAgentFunctionEnabled);
            this.persister.saveAdministrationConfiguration(administrationConfiguration);
            if (!remoteAgentFunctionEnabled) {
                this.elasticFunctionalityFacade.setElasticSupportEnabled(false);
            }
        }
    }

    private void startOrStopConnectors(boolean started) throws Exception {
        if (started) {
            this.brokerService.addStartedConnectors(this.baseBrokerUri);
        } else {
            this.brokerService.removeAllConnectors();
        }
    }

    public boolean isRemoteAgentFunctionEnabled() {
        return this.persister.getAdministrationConfiguration().isRemoteAgentFunctionEnabled();
    }

    public void stopRemoteAgent(@NotNull BuildAgent agent) {
        this.agentManager.stopAgent(agent);
    }

    public void bootstrapping(String agentHostName) {
        this.addRemoteAgentLogEntry("A remote agent is loading on " + (agentHostName == null ? "an unknown host" : agentHostName) + ".");
    }

    public void bootstrappingEphemeral(String agentHostName) {
        this.addRemoteAgentLogEntry("An ephemeral agent is loading on " + (agentHostName == null ? "an unknown host" : agentHostName) + ".");
    }

    public void bootstrappingElastic(String agentHostName, @Nullable String instanceId) {
        this.addRemoteAgentLogEntry("An elastic agent is loading on " + (agentHostName == null ? "an unknown host" : agentHostName) + ".");
        if (instanceId != null) {
            this.elasticFunctionalityFacade.updateAgentPendingStatus(instanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    String ensureUniqueName(String currentName) {
        String string = currentName.intern();
        synchronized (string) {
            if (this.agentManager.getAgentDefinitionByName(currentName) == null) {
                return currentName;
            }
            List otherAgents = this.agentManager.getAgentDefinitionsWithNameLike(RemoteAgentManagerImpl.getLikeName(currentName));
            int max = 1;
            for (PipelineDefinition agent : otherAgents) {
                int agentNumber;
                String[] nameAndNumber = RemoteAgentManagerImpl.splitIntoNameAndSuffix(agent.getName());
                if (nameAndNumber.length != 2 || (agentNumber = Integer.parseInt(nameAndNumber[1])) <= max) continue;
                max = agentNumber;
            }
            return RemoteAgentManagerImpl.splitIntoNameAndSuffix(currentName)[0] + " (" + (max + 1) + ")";
        }
    }

    @VisibleForTesting
    static String getLikeName(@NotNull String currentName) {
        return RemoteAgentManagerImpl.splitIntoNameAndSuffix(currentName)[0] + " (%)";
    }

    @NotNull
    private static String[] splitIntoNameAndSuffix(@NotNull String currentName) {
        Matcher matcher = SPLIT_NAME_AND_NUMBER.matcher(currentName);
        if (matcher.find()) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        return new String[]{currentName};
    }

    private boolean isAlive(BuildAgentImpl remoteAgent, long gracePeriod) {
        long difference;
        boolean restoreState = this.featureManager.isSeamlessRestartEnabled();
        if (restoreState && this.connectorsStartDate == null) {
            return true;
        }
        Date date = remoteAgent.getLastUpdated();
        if (restoreState && date.before(this.connectorsStartDate)) {
            date = this.connectorsStartDate;
        }
        return (difference = System.currentTimeMillis() - date.getTime()) <= Duration.ofSeconds(this.heartbeatTimeoutSeconds).plusMillis(gracePeriod).toMillis();
    }

    public void addRemoteAgentLogEntry(String logEntry) {
        this.addRemoteAgentLogEntry(Level.INFO, logEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteAgentLogEntry(Level level, String logEntry) {
        log.log(level, logEntry);
        LinkedList<String> linkedList = this.remoteAgentLog;
        synchronized (linkedList) {
            this.remoteAgentLog.add(DateFormat.getDateTimeInstance().format(new Date()) + "  " + logEntry);
            while (this.remoteAgentLog.size() > 15) {
                this.remoteAgentLog.removeFirst();
            }
        }
    }

    public void stopConnectors() throws Exception {
        this.startOrStopConnectors(false);
    }

    @VisibleForTesting
    void updateCapabilities(@NotNull CapabilitySet existingCapabilitySet, @NotNull ReadOnlyCapabilitySet newCapabilitySet) {
        Set existingCapabilities = existingCapabilitySet.getCapabilities().stream().map(Capability::getKey).collect(Collectors.toCollection(HashSet::new));
        Set updatableCapabilities = existingCapabilitySet.getCapabilities().stream().filter(RemoteAgentManagerImpl::isCapabilityUpdatable).map(Capability::getKey).collect(Collectors.toCollection(HashSet::new));
        Set newCapabilities = newCapabilitySet.getCapabilities().stream().filter(RemoteAgentManagerImpl::isCapabilityUpdatable).collect(Collectors.toSet());
        for (Capability newCapability : newCapabilities) {
            String newCapabilityKey = newCapability.getKey();
            if (existingCapabilities.contains(newCapabilityKey)) {
                if (updatableCapabilities.contains(newCapabilityKey)) {
                    Capability existingCapability = existingCapabilitySet.getCapability(newCapabilityKey);
                    if (existingCapability.getCapabilitySource() == null) {
                        if (Objects.equals(existingCapability.getValue(), newCapability.getValue())) {
                            log.info(String.format("Updating capability %s source to %s", existingCapability, newCapability.getCapabilitySource()));
                            existingCapability.setCapabilitySource(newCapability.getCapabilitySource());
                        } else {
                            log.info(String.format("Existing capability %s has different value then capability %s. Setting source to UI", existingCapability, newCapability));
                            existingCapability.setCapabilitySource(CapabilitySource.UI);
                        }
                    } else if (!existingCapability.equals(newCapability)) {
                        log.debug(String.format("Updating capability %s to %s", existingCapability, newCapability));
                        existingCapabilitySet.addCapability(newCapability, true);
                    }
                    updatableCapabilities.remove(newCapabilityKey);
                    continue;
                }
                log.debug(String.format("Existing capability %s has higher source than %s and won't be updated", existingCapabilitySet.getCapability(newCapabilityKey), newCapability));
                continue;
            }
            log.debug(String.format("Adding new capability %s", newCapability));
            existingCapabilitySet.addCapability(newCapability);
        }
        for (String updatableCapabilityKey : updatableCapabilities) {
            Capability existingCapability = existingCapabilitySet.getCapability(updatableCapabilityKey);
            if (existingCapability.getCapabilitySource() == null) {
                log.debug(String.format("Setting %s source to UI", updatableCapabilityKey));
                existingCapability.setCapabilitySource(CapabilitySource.UI);
                continue;
            }
            log.debug(String.format("Removing capability %s, since it's not present anymore", updatableCapabilityKey));
            existingCapabilitySet.removeCapability(updatableCapabilityKey);
        }
    }

    public void start() throws Exception {
        this.connectorsStartDate = new Date();
        this.startOrStopConnectors(this.isRemoteAgentFunctionEnabled());
    }

    public List<String> getRemoteAgentLog() {
        return new LinkedList<String>(this.remoteAgentLog);
    }

    public void setHeartbeatCheckInterval(int heartbeatCheckInterval) {
        this.heartbeatCheckInterval = heartbeatCheckInterval;
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public void setUri(String uri) {
        this.baseBrokerUri = URI.create(uri);
    }

    private static boolean isCapabilityUpdatable(@NotNull Capability capability) {
        return capability.getCapabilitySource() == null || capability.getCapabilitySource().compareTo((Enum)CapabilitySource.UI) > 0;
    }

    private void updateReturningAgentStatus(BuildAgent existingAgent, DistributedProperties existingAgentDefinition) {
        existingAgentDefinition.setLastStartupTime(new Date());
        existingAgentDefinition.setLastShutdownTime(null);
        BuildAgentImpl buildAgent = (BuildAgentImpl)Narrow.downTo((Object)existingAgent, BuildAgentImpl.class);
        if (buildAgent != null) {
            log.debug(String.format("Setting agent %d status to idle", existingAgent.getId()));
            buildAgent.setAgentStatus((AgentStatus)AgentIdleStatus.getInstance());
            buildAgent.setLastUpdated(new Date());
        }
    }

    private class ReturningAgentPipelineDefinitionVisitor
    implements PipelineDefinitionVisitor {
        private ReturningAgentPipelineDefinitionVisitor() {
        }

        public void visitElastic(ElasticAgentDefinition returningAgentDefinition) {
            log.debug(String.format("Registering returning elastic agent %d", returningAgentDefinition.getId()));
            BuildAgent existingAgent = RemoteAgentManagerImpl.this.agentManager.getAgent(returningAgentDefinition.getId());
            if (existingAgent == null) {
                throw new IllegalArgumentException(String.format("Elastic agent with id %d doesn't exist", returningAgentDefinition.getId()));
            }
            Preconditions.checkArgument((existingAgent.getType() == AgentType.ELASTIC ? 1 : 0) != 0, (Object)("Registration of an elastic agent failed. There is already an agent of another type with the same id registered (" + existingAgent.getId() + ")."));
            ElasticAgentDefinition existingAgentDefinition = (ElasticAgentDefinition)existingAgent.getDefinition();
            Preconditions.checkArgument((boolean)existingAgentDefinition.getElasticInstanceId().equals(returningAgentDefinition.getElasticInstanceId()), (Object)String.format("Elastic agent instance id %s is not matching instance id on server", returningAgentDefinition.getElasticInstanceId()));
            Preconditions.checkArgument((existingAgentDefinition.getElasticImageConfigurationId() == returningAgentDefinition.getElasticImageConfigurationId() ? 1 : 0) != 0, (Object)String.format("Elastic agent image configuration id %d is not matching image configuration on server", returningAgentDefinition.getElasticImageConfigurationId()));
            if (existingAgent.getAgentStatus() instanceof AgentOfflineStatus || existingAgent.isRequestedToBeStopped()) {
                throw new RuntimeException(String.format("Elastic agent with id %d is already offline. Cannot register it", returningAgentDefinition.getId()));
            }
            RemoteAgentManagerImpl.this.updateReturningAgentStatus(existingAgent, (DistributedProperties)existingAgentDefinition);
            RemoteAgentManagerImpl.this.agentManager.saveReturningElasticPipeline(existingAgentDefinition);
            RemoteAgentManagerImpl.this.agentManager.abandonBuild(existingAgent, true);
            RemoteAgentManagerImpl.this.addRemoteAgentLogEntry("Elastic agent [" + returningAgentDefinition.getName() + "] came back after a period of inactivity.");
        }

        public void visitEphemeral(EphemeralAgentDefinition returningAgentDefinition) {
            log.debug(String.format("Registering returning ephemeral agent %d", returningAgentDefinition.getId()));
            BuildAgent existingAgent = RemoteAgentManagerImpl.this.agentManager.getAgent(returningAgentDefinition.getId());
            if (existingAgent == null) {
                throw new EphemeralNotExistAnymoreException(String.format("Ephemeral agent with id %d doesn't exist", returningAgentDefinition.getId()));
            }
            Preconditions.checkArgument((existingAgent.getType() == AgentType.EPHEMERAL ? 1 : 0) != 0, (Object)("Registration of an ephemeral agent failed. There is already an agent of another type with the same id registered (" + existingAgent.getId() + ")."));
            EphemeralAgentDefinition existingAgentDefinition = (EphemeralAgentDefinition)existingAgent.getDefinition();
            Preconditions.checkArgument((existingAgentDefinition.getEphemeralAgentTemplateId() == returningAgentDefinition.getEphemeralAgentTemplateId() ? 1 : 0) != 0, (Object)String.format("Ephemeral agent template configuration id %d is not matching template configuration on server", returningAgentDefinition.getEphemeralAgentTemplateId()));
            if (existingAgent.getAgentStatus() instanceof AgentOfflineStatus || existingAgent.isRequestedToBeStopped()) {
                RemoteAgentManagerImpl.this.agentManager.removeEphemeralAgent(existingAgent.getId());
                throw new EphemeralNotExistAnymoreException(String.format("Ephemeral agent with id %d is already offline. Cannot register it", returningAgentDefinition.getId()));
            }
            RemoteAgentManagerImpl.this.updateReturningAgentStatus(existingAgent, (DistributedProperties)existingAgentDefinition);
            RemoteAgentManagerImpl.this.agentManager.saveEphemeralPipeline(existingAgentDefinition);
            RemoteAgentManagerImpl.this.agentManager.abandonBuild(existingAgent, true);
        }

        public void visitLocal(LocalAgentDefinition pipelineDefinition) {
            log.error("Local agents cannot register as remote");
            throw new IllegalArgumentException("Local agent already has id: " + pipelineDefinition.getId() + ", and cannot be registered.");
        }

        public void visitRemote(RemoteAgentDefinition returningAgentDefinition) {
            boolean shouldPublishEvent;
            ImmutableSet previouslyExistingCapabilities;
            boolean agentWasOffline;
            BuildAgent existingAgent = RemoteAgentManagerImpl.this.agentManager.getAgent(returningAgentDefinition.getId());
            if (existingAgent == null) {
                returningAgentDefinition.setId(-1L);
                return;
            }
            Preconditions.checkArgument((existingAgent.getDefinition().getType() == AgentType.REMOTE ? 1 : 0) != 0, (Object)("Registration of remote agent failed. There is already an agent of another type with the same id registered (" + existingAgent.getId() + ")."));
            RemoteAgentDefinition existingAgentDefinition = (RemoteAgentDefinition)existingAgent.getDefinition();
            if (RemoteAgentManagerImpl.this.remoteAgentAuthenticationManager.isRemoteAgentAuthenticationEnabled()) {
                Preconditions.checkState((existingAgentDefinition.getUuid() == null || existingAgentDefinition.getUuid().equals(returningAgentDefinition.getUuid()) ? 1 : 0) != 0, (Object)String.format("Registration of remote agent failed. Agent id %d is already mapped to a different uuid: (requested uuid is %s)", existingAgent.getId(), returningAgentDefinition.getUuid()));
            }
            if (!(agentWasOffline = existingAgent.getAgentStatus() instanceof AgentOfflineStatus)) {
                RemoteAgentManagerImpl.this.agentManager.onAgentReturning(existingAgent);
                RemoteAgentManagerImpl.this.addRemoteAgentLogEntry("Remote agent [" + returningAgentDefinition.getName() + "] marked as inactive. A new one came in place.");
            }
            existingAgent.setRequestedToBeStopped(false);
            CapabilitySet existingCapabilitySet = existingAgentDefinition.getCapabilitySet();
            CapabilitySet newCapabilitySet = returningAgentDefinition.getCapabilitySet();
            ImmutableSet immutableSet = previouslyExistingCapabilities = existingCapabilitySet != null ? ImmutableSet.copyOf((Collection)existingCapabilitySet.getCapabilities()) : null;
            if (existingCapabilitySet != null) {
                if (newCapabilitySet != null && !DISABLE_AGENT_UPDATE_CAPABILITIES_ON_START) {
                    RemoteAgentManagerImpl.this.updateCapabilities(existingCapabilitySet, (ReadOnlyCapabilitySet)newCapabilitySet);
                } else {
                    if (DISABLE_AGENT_UPDATE_CAPABILITIES_ON_START) {
                        log.info(String.format("Not updating capabilities from bamboo-capabilities.properties since the %s flag is set to true", SystemProperty.DISABLE_AGENT_CAPABILITY_UPDATE.getKey()));
                    }
                    returningAgentDefinition.setCapabilitySet(existingCapabilitySet);
                }
            } else {
                existingAgentDefinition.setCapabilitySet(newCapabilitySet);
            }
            RemoteAgentManagerImpl.this.updateReturningAgentStatus(existingAgent, (DistributedProperties)existingAgentDefinition);
            CapabilitySet capabilitySetToSave = existingAgentDefinition.getCapabilitySet();
            boolean wasNullAndIsNull = capabilitySetToSave == previouslyExistingCapabilities;
            boolean bl = shouldPublishEvent = agentWasOffline || wasNullAndIsNull || capabilitySetToSave != null && !SetUtils.isEqualSet((Collection)capabilitySetToSave.getCapabilities(), (Collection)previouslyExistingCapabilities);
            if (shouldPublishEvent) {
                RemoteAgentManagerImpl.this.agentManager.savePipeline((PipelineDefinition)existingAgentDefinition);
            } else {
                RemoteAgentManagerImpl.this.agentManager.savePipeline((PipelineDefinition)existingAgentDefinition, null);
            }
            RemoteAgentManagerImpl.this.agentManager.abandonBuild(existingAgent, true);
            RemoteAgentManagerImpl.this.addRemoteAgentLogEntry("Remote agent [" + returningAgentDefinition.getName() + "] came back after a period of inactivity.");
        }
    }
}

