/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.event.ServerStartedEvent;
import com.atlassian.bamboo.health.BambooHealthCheckService;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.PluginController;
import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;

public class FeatureManagerStartupListener {
    private static final Logger lifecycleLog = Logger.getLogger((String)"com.atlassian.bamboo.lifecycle");
    private final PluginController pluginController;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final AdministrationConfigurationPersister administrationConfigurationPersister;
    private final BambooHealthCheckService healthCheckService;
    private final ApplicationLinkService applicationLinkService;

    public FeatureManagerStartupListener(PluginController pluginController, AdministrationConfigurationAccessor administrationConfigurationAccessor, AdministrationConfigurationPersister administrationConfigurationPersister, BambooHealthCheckService healthCheckService, ApplicationLinkService applicationLinkService) {
        this.pluginController = pluginController;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.administrationConfigurationPersister = administrationConfigurationPersister;
        this.healthCheckService = healthCheckService;
        this.applicationLinkService = applicationLinkService;
    }

    @EventListener
    public void handleEvent(ServerStartedEvent event) {
        lifecycleLog.info((Object)("Starting " + this.getClass().getSimpleName()));
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        Iterable links = this.applicationLinkService.getApplicationLinks();
        if (Iterables.isEmpty((Iterable)links)) {
            lifecycleLog.info((Object)"***********************************");
            lifecycleLog.info((Object)"* NO application links configured *");
            lifecycleLog.info((Object)"***********************************");
        } else {
            lifecycleLog.info((Object)"*******************************");
            lifecycleLog.info((Object)"* Application links configured*");
            for (ApplicationLink link : links) {
                lifecycleLog.info((Object)("* Application Link. Id:'" + link.getId() + "', Name: '" + link.getName() + "', Url:'" + link.getDisplayUrl() + ", Type: '" + link.getType().getI18nKey() + "'"));
            }
            lifecycleLog.info((Object)"********************************");
        }
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
    }

    private void disableModule(String completeKey) {
        this.pluginController.disablePluginModule(completeKey);
        this.healthCheckService.ignoreDisabledPluginModule(completeKey);
    }

    private void disablePlugin(String key) {
        this.pluginController.disablePlugin(key);
        this.healthCheckService.ignoreDisabledPlugin(key);
    }
}

