/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.event;

import com.atlassian.bamboo.amq.AgentJmsUtils;
import com.atlassian.bamboo.amq.BambooBrokerControllerImpl;
import com.atlassian.bamboo.amq.BrokerStartAware;
import com.atlassian.bamboo.event.RemoteBroadcastEvent;
import com.atlassian.bamboo.event.ServerFingerprintBroadcastEventV2;
import com.atlassian.bamboo.setup.ServerFingerprint;
import com.atlassian.bamboo.util.BambooDebugUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.events.ExecutableQueueUpdate;
import com.atlassian.event.api.EventListener;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.transport.RequestTimedOutIOException;
import org.apache.log4j.Logger;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class RemoteBroadcastEventListener
implements BrokerStartAware {
    private static final Logger log = Logger.getLogger(RemoteBroadcastEventListener.class);
    @Inject
    private JmsTemplate remoteEventsJmsTemplate;
    @Inject
    private JmsTemplate remoteEventsLongLivedJmsTemplate;
    @Inject
    private ServerFingerprint fingerprint;
    @Inject
    private BambooBrokerControllerImpl bambooBrokerController;
    private ExecutorService executorService;
    private AtomicBoolean active = new AtomicBoolean(false);
    private int broadcastDowntimeMultiplier = 0;
    private final BroadcastQueue broadcastQueue = new BroadcastQueue();
    private final MessagePostProcessor fingerPrintStamper = new MessagePostProcessor(){

        public Message postProcessMessage(Message message) throws JMSException {
            AgentJmsUtils.setFingerprint(message, RemoteBroadcastEventListener.this.fingerprint);
            return message;
        }
    };

    @Override
    public void onBrokerStarted() {
        this.active.set(true);
    }

    @PostConstruct
    private void init() {
        this.bambooBrokerController.registerBrokerStartListener(this);
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new CustomizableThreadFactory("RemoteEventBroadcast-"));
    }

    @EventListener
    public void onEvent(RemoteBroadcastEvent eventArg) {
        if (!this.active.get()) {
            log.info((Object)("Event broadcast not yet active, event: " + eventArg));
            return;
        }
        this.broadcastQueue.add(eventArg);
        this.executorService.submit(() -> {
            while (!this.broadcastQueue.isEmpty()) {
                try {
                    RemoteBroadcastEvent event;
                    long delaySeconds = SystemProperty.REMOTE_BROADCAST_DOWNTIME_INCREMENT_SECONDS.getTypedValue() * Math.min((long)this.broadcastDowntimeMultiplier, SystemProperty.REMOTE_BROADCAST_DOWNTIME_MAX_MULTIPLIER.getTypedValue());
                    if (delaySeconds > 0L) {
                        try {
                            log.warn((Object)("Sleeping " + delaySeconds + " seconds before broadcasting event because of previous failure"));
                            Thread.sleep(TimeUnit.SECONDS.toMillis(delaySeconds));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    JmsTemplate jmsTemplate = (event = this.broadcastQueue.poll()).appliesToEphemeralAgents() ? this.remoteEventsJmsTemplate : this.remoteEventsLongLivedJmsTemplate;
                    ServerFingerprintBroadcastEventV2 fingerprintBroadcastEventV2 = (ServerFingerprintBroadcastEventV2)Narrow.downTo((Object)event, ServerFingerprintBroadcastEventV2.class);
                    if (fingerprintBroadcastEventV2 != null) {
                        jmsTemplate.convertAndSend((Object)event, (MessagePostProcessor)new FingerprintStamper(fingerprintBroadcastEventV2.getFingerprintForJmsMessage()));
                    } else {
                        jmsTemplate.convertAndSend((Object)event, this.fingerPrintStamper);
                    }
                    this.broadcastDowntimeMultiplier = 0;
                }
                catch (JmsException e) {
                    if (this.isTimeoutException(e)) {
                        log.warn((Object)"Broadcast failed with timeout, backing off...");
                        ++this.broadcastDowntimeMultiplier;
                    }
                    Logger emergencyLog = BambooDebugUtils.emergencyLog();
                    String message = "Caught " + ((Object)((Object)e)).getClass().getSimpleName();
                    log.info((Object)message);
                    if (emergencyLog.isInfoEnabled()) {
                        emergencyLog.info((Object)message, (Throwable)e);
                        emergencyLog.info((Object)BambooDebugUtils.getAllStackTraces((BambooDebugUtils.ThreadDumpReason)BambooDebugUtils.ThreadDumpReason.MQ_SEND_TIMEOUT));
                    }
                    throw e;
                }
            }
        });
    }

    private boolean isTimeoutException(Throwable e) {
        if (e instanceof RequestTimedOutIOException) {
            return true;
        }
        if (e.getCause() != null) {
            return this.isTimeoutException(e.getCause());
        }
        return false;
    }

    private static class BroadcastQueue {
        final Queue<RemoteBroadcastEvent> queue = new LinkedList<RemoteBroadcastEvent>();
        final Set<Long> affectedAgentsIds = new HashSet<Long>();
        private int queueUpdateEventCount = 0;

        private BroadcastQueue() {
        }

        public synchronized void add(RemoteBroadcastEvent event) {
            ExecutableQueueUpdate executableQueueUpdate = (ExecutableQueueUpdate)Narrow.downTo((Object)event, ExecutableQueueUpdate.class);
            if (executableQueueUpdate != null) {
                if (this.queueUpdateEventCount == 0) {
                    this.queue.add(event);
                }
                Iterables.addAll(this.affectedAgentsIds, (Iterable)executableQueueUpdate.getAffectedAgentIds());
                ++this.queueUpdateEventCount;
            } else {
                this.queue.add(event);
            }
        }

        public synchronized RemoteBroadcastEvent poll() {
            RemoteBroadcastEvent event = this.queue.poll();
            ExecutableQueueUpdate executableQueueUpdate = (ExecutableQueueUpdate)Narrow.downTo((Object)event, ExecutableQueueUpdate.class);
            if (executableQueueUpdate != null) {
                ExecutableQueueUpdate eventToReturn = executableQueueUpdate;
                if (this.queueUpdateEventCount > 1) {
                    eventToReturn = new ExecutableQueueUpdate("joining " + this.queueUpdateEventCount + " queue update events");
                    log.debug((Object)("joining " + this.queueUpdateEventCount + " queue update events"));
                    eventToReturn.setAffectedAgentIds(this.affectedAgentsIds);
                }
                this.queueUpdateEventCount = 0;
                this.affectedAgentsIds.clear();
                return eventToReturn;
            }
            return event;
        }

        public synchronized boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }

    private static class FingerprintStamper
    implements MessagePostProcessor {
        private final ServerFingerprint fingerprint;

        public FingerprintStamper(ServerFingerprint fingerprint) {
            this.fingerprint = fingerprint;
        }

        public Message postProcessMessage(Message message) throws JMSException {
            AgentJmsUtils.setFingerprint(message, this.fingerprint);
            return message;
        }
    }
}

