/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.process.UnixProcessManagement;
import com.atlassian.bamboo.process.WindowsProcessManagement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;

public abstract class ProcessManagement {
    private static String[] BANNER = new String[]{"Force Stop build feature is enabled for current plan. Either Bamboo has detected the build has hung or it has been manually stopped."};
    private static final int INITIAL_SIZE_OF_PIDS_SET = 64;
    private static final long TIMEOUT_FOR_PROCESS_TO_FINISH_MILLIS = 5000L;
    private static ProcessManagement _instance;
    protected static final Logger log;
    private BuildLogger buildLogger;

    protected ProcessManagement() {
    }

    public static synchronized ProcessManagement getInstance(BuildLogger buildLogger) throws Exception {
        if (null == _instance) {
            if (ProcessManagement.isMac() || ProcessManagement.isUnix()) {
                _instance = new UnixProcessManagement();
            } else if (ProcessManagement.isWindows()) {
                _instance = new WindowsProcessManagement();
            } else {
                throw new Exception("Environment: " + System.getProperty("os.name").toLowerCase() + " not supported");
            }
        }
        _instance.setBuildLogger(buildLogger);
        return _instance;
    }

    public abstract String getPsDetectionCommand();

    public static boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static boolean isMac() {
        return SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX;
    }

    public static boolean isUnix() {
        return SystemUtils.IS_OS_UNIX || SystemUtils.IS_OS_LINUX;
    }

    public abstract void generateStackTrace(int var1, String var2);

    private void gentlyKillProcess(String pid) {
        log.info((Object)this.buildLog("Killing: " + pid, false));
        this.executeCommand(this.getGentleKillCmd(pid));
    }

    private Map<Integer, Map<String, String>> rudelyKillProcess(String pid, String cmd, Map<Integer, Map<String, String>> pids) {
        Integer pidInt;
        try {
            pidInt = Integer.valueOf(pid);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Failed to kill process, invalid pid: " + pid), (Throwable)e);
            return pids;
        }
        if (pids.containsKey(pidInt)) {
            pids = this.getPids();
        }
        if (pids.containsKey(pidInt) && cmd.equals(pids.get(pidInt).get("command"))) {
            log.info((Object)("pid: " + pid + " still present in the process table. Process: " + this.formatCommandSafely(cmd)));
            log.debug((Object)("pid: " + pid + " process name with args: " + cmd));
            log.info((Object)this.buildLog("Killing: " + pid, false));
            this.executeCommand(this.getRudeKillCmd(pid));
        }
        return pids;
    }

    public abstract String getGentleKillCmd(String var1);

    public abstract String getRudeKillCmd(String var1);

    public void getStackTraceAndKillRelatedProcesses(int pid) throws Exception {
        Map p;
        int i;
        for (String s : BANNER) {
            log.info((Object)this.buildLog(s, true));
        }
        log.info((Object)this.buildLog("Attempting to generate stack trace and terminate spawned sub-processes of process id: " + pid, false));
        Map<Integer, Map<String, String>> pids = this.getPids();
        Set<Map<String, String>> related = this.getRelatedProcesses(pid, pids);
        log.info((Object)this.buildLog("getStackTraceAndKillRelatedProcesses for " + related.size() + " processes", false));
        Object[] relatedPids = related.toArray();
        log.info((Object)"getting stack trace");
        for (i = relatedPids.length - 1; i > -1; --i) {
            p = (Map)relatedPids[i];
            this.generateStackTrace(Integer.parseInt((String)p.get("pid")), (String)p.get("command"));
        }
        this.sleep(5000L);
        log.info((Object)"gently killing pids");
        for (i = relatedPids.length - 1; i > -1; --i) {
            p = (Map)relatedPids[i];
            this.gentlyKillProcess((String)p.get("pid"));
        }
        this.sleep(5000L);
        pids = this.getPids();
        log.info((Object)"rudely killing pids (only if necessary)");
        for (i = relatedPids.length - 1; i > -1; --i) {
            p = (Map)relatedPids[i];
            pids = this.rudelyKillProcess((String)p.get("pid"), (String)p.get("command"), pids);
        }
        for (String s : BANNER) {
            log.info((Object)this.buildLog(s, false));
        }
        log.info((Object)this.buildLog("Has finished generating stack trace and terminating spawned sub-processes of process id: " + pid, false));
    }

    public void sleep(long milliseconds) throws Exception {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            log.error((Object)"error while waiting for the process to finish.", (Throwable)e);
            throw e;
        }
    }

    public String buildLog(String message, boolean isError) {
        if (this.buildLogger != null) {
            if (isError) {
                this.buildLogger.addErrorLogEntry(message);
            } else {
                this.buildLogger.addBuildLogEntry(message);
            }
        }
        return message;
    }

    void executeCommand(String cmd) {
        this.executeCommand(cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(String command, boolean readOutput) {
        block8: {
            log.info((Object)this.buildLog("Executing " + command, false));
            try {
                Process p = Runtime.getRuntime().exec(command);
                if (!readOutput) break block8;
                ExecutorService es = Executors.newFixedThreadPool(2);
                Future<?> stdErrFuture = es.submit(new ProcessOutputReader(p.getErrorStream()));
                Future<?> stdOutFuture = es.submit(new ProcessOutputReader(p.getInputStream()));
                try {
                    stdErrFuture.get();
                    stdOutFuture.get();
                }
                catch (Exception e) {
                    String message = MessageFormat.format("exception happened while reading output of {0}:\n{1}", command, Throwables.getStackTraceAsString((Throwable)e));
                    log.error((Object)message);
                    this.buildLog(message, true);
                }
                finally {
                    if (es != null) {
                        es.shutdownNow();
                    }
                }
            }
            catch (IOException e) {
                String message = "exception happened while executing the command: " + command;
                log.error((Object)this.buildLog(message, true));
                log.error((Object)e.getStackTrace());
                this.buildLog(Arrays.toString(e.getStackTrace()), true);
            }
        }
    }

    public Set<Map<String, String>> getRelatedProcesses(int pid, Map<Integer, Map<String, String>> pids) {
        log.info((Object)("getRelatedProcesses PID: " + pid));
        LinkedHashSet<Map<String, String>> related = new LinkedHashSet<Map<String, String>>(64);
        this.recurseDescendantProcesses(pid, pids, related);
        log.info((Object)("related size: " + related.size()));
        this.setRelatedOrphansInTheRelatedSet(pid, pids, related);
        log.info((Object)("related size: " + related.size()));
        for (Map map : related) {
            String message = "Found related process: pid: " + (String)map.get("pid") + " ppid: " + (String)map.get("ppid") + " pgid: " + (String)map.get("pgid") + " %cpu: " + (String)map.get("%cpu") + " %mem: " + (String)map.get("%mem") + " cmd: " + this.formatCommandSafely((String)map.get("command"));
            log.info((Object)message);
            this.buildLog(message, false);
        }
        return related;
    }

    public Map<Integer, Map<String, String>> getPids() {
        return null;
    }

    private Set<Map<String, String>> getChildrenPids(int pid, Map<Integer, Map<String, String>> pids) {
        HashSet<Map<String, String>> children_pids = new HashSet<Map<String, String>>();
        for (int p : pids.keySet()) {
            String ppid = pids.get(p).get("ppid");
            String cmd = pids.get(p).get("command");
            if (this.getPsDetectionCommand().equals(cmd) || !ppid.equals(Integer.toString(pid))) continue;
            children_pids.add(pids.get(p));
        }
        log.info((Object)("returning: " + children_pids.size() + " children from pid: " + pid));
        return children_pids;
    }

    @VisibleForTesting
    void recurseDescendantProcesses(int pid, Map<Integer, Map<String, String>> pids, Set<Map<String, String>> related) {
        log.info((Object)("getting children pids for pid: " + pid));
        Set<Map<String, String>> children = this.getChildrenPids(pid, pids);
        related.addAll(children);
        if (children.isEmpty()) {
            log.debug((Object)"0 children, finishing recursion...");
        } else {
            for (Map<String, String> r : children) {
                int child_pid = Integer.parseInt(r.get("pid"));
                log.debug((Object)("getting descendants for pid: " + child_pid));
                this.recurseDescendantProcesses(child_pid, pids, related);
            }
        }
    }

    private void setRelatedOrphansInTheRelatedSet(int pid, Map<Integer, Map<String, String>> pids, Set<Map<String, String>> related) {
        if (ProcessManagement.isWindows()) {
            return;
        }
        Set<Map<String, String>> children = this.getChildrenPids(1, pids);
        log.debug((Object)("Getting " + children.size() + " children of the INIT process."));
        String pgid = pids.get(pid).get("pgid");
        String pidTest = Integer.toString(pid);
        log.info((Object)("Looking for orphans processes of PID: " + pidTest + " PGID: " + pgid));
        for (Map<String, String> p : children) {
            String newPid = p.get("pid");
            if (pidTest.equals(newPid) || this.getPsDetectionCommand().equals(p.get("command")) || !pgid.equals(p.get("pgid")) || this.isAscendant(pid, Integer.parseInt(newPid), pids)) continue;
            related.add(p);
            log.info((Object)("Adding orphan with pid:" + p.get("pid") + " since the pgid: " + pgid + " is the same."));
        }
    }

    private boolean isAscendant(int sourcePid, int possibleAscendantPid, Map<Integer, Map<String, String>> pids) {
        int npid;
        log.debug((Object)("analizing if: " + sourcePid + " is descendant of " + possibleAscendantPid));
        boolean isAscendant = false;
        String ppid = Integer.toString(sourcePid);
        do {
            log.debug((Object)("ppid: " + ppid));
            npid = Integer.parseInt(ppid);
            if (pids.containsKey(npid)) {
                ppid = pids.get(npid).get("ppid");
                if (npid != possibleAscendantPid) continue;
                log.info((Object)(sourcePid + " is a descendant of " + possibleAscendantPid + "! Not adding it in the descendants list"));
                isAscendant = true;
                break;
            }
            ppid = null;
        } while (ppid != null && npid != 1);
        return isAscendant;
    }

    private String formatCommandSafely(String command) {
        return command.split(" ")[0];
    }

    private void setBuildLogger(BuildLogger buildLogger) {
        this.buildLogger = buildLogger;
    }

    static {
        log = Logger.getLogger(ProcessManagement.class);
    }

    private class ProcessOutputReader
    implements Runnable {
        private final InputStream is;

        ProcessOutputReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            for (String line : IOUtils.readLines((InputStream)this.is, (Charset)Charset.defaultCharset())) {
                ProcessManagement.this.buildLog(line, false);
            }
        }
    }
}

