/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.process.ProcessManagement;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class UnixProcessManagement
extends ProcessManagement {
    public static final int COMMAND_COMPONENTS_LENGTH = 7;

    @Override
    public Map<Integer, Map<String, String>> getPids() {
        HashMap<Integer, Map<String, String>> pids = new HashMap<Integer, Map<String, String>>();
        String command = this.getPsDetectionCommand();
        try {
            Process p = Runtime.getRuntime().exec(command);
            this.parseProcessesList(p.getInputStream(), pids);
        }
        catch (Exception e) {
            log.error((Object)e.toString());
            log.debug(null, (Throwable)e);
        }
        return pids;
    }

    @VisibleForTesting
    void parseProcessesList(InputStream inputStream, Map<Integer, Map<String, String>> pids) throws IOException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            input.readLine();
            while ((line = input.readLine()) != null) {
                HashMap<String, String> pid_info = new HashMap<String, String>();
                String[] line_components = (line = line.trim()).split("\\s+", 7);
                if (line_components.length < 7) continue;
                int index = 0;
                pid_info.put("pid", line_components[index]);
                pid_info.put("ppid", line_components[++index]);
                pid_info.put("pgid", line_components[++index]);
                pid_info.put("user", line_components[++index]);
                pid_info.put("%cpu", line_components[++index]);
                pid_info.put("%mem", line_components[++index]);
                pid_info.put("command", line_components[++index]);
                ++index;
                pids.put(Integer.parseInt((String)pid_info.get("pid")), pid_info);
            }
        }
    }

    @Override
    public String getPsDetectionCommand() {
        return "ps -eo pid,ppid,pgid,user,%cpu,%mem,command";
    }

    @Override
    public void generateStackTrace(int pid, String command) {
        String cmd = "kill -3 " + Integer.toString(pid);
        super.executeCommand(cmd, true);
    }

    @Override
    public String getGentleKillCmd(String pid) {
        return "kill " + pid;
    }

    @Override
    public String getRudeKillCmd(String pid) {
        return "kill -9 " + pid;
    }
}

