/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.bamboo.process.ProcessManagement;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class WindowsProcessManagement
extends ProcessManagement {
    private static final String CMD = "CommandLine";
    private static final String PPID = "ParentProcessId";
    private static final String PID = "ProcessId";
    private static final String MEMORY = "WorkingSetSize";
    private static final int LINE_MIN_LENGTH = 5;
    private Map<String, Limits> components = new HashMap<String, Limits>();

    @Override
    public Map<Integer, Map<String, String>> getPids() {
        HashMap<Integer, Map<String, String>> pids = new HashMap<Integer, Map<String, String>>();
        String command = this.getPsDetectionCommand();
        try {
            log.debug((Object)("executing: " + command));
            Process p = Runtime.getRuntime().exec(command);
            this.parseProcessesList(p.getInputStream(), pids);
        }
        catch (Exception e) {
            log.error((Object)e.toString());
            log.debug(null, (Throwable)e);
        }
        return pids;
    }

    @VisibleForTesting
    void parseProcessesList(InputStream inputStream, Map<Integer, Map<String, String>> pids) throws IOException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));){
            this.components.clear();
            String line = input.readLine();
            log.debug((Object)("getting offsets from: " + line));
            this.components.put(CMD, new Limits(line.indexOf(CMD), line.indexOf(PPID)));
            this.components.put(PPID, new Limits(line.indexOf(PPID), line.indexOf(PID)));
            this.components.put(PID, new Limits(line.indexOf(PID), line.indexOf(MEMORY)));
            while ((line = input.readLine()) != null) {
                HashMap<String, String> pid_info = new HashMap<String, String>();
                if (line.length() < 5) continue;
                pid_info.put("command", line.substring(this.components.get((Object)CMD).begin, this.components.get((Object)CMD).end).trim());
                pid_info.put("pid", line.substring(this.components.get((Object)PID).begin, this.components.get((Object)PID).end).trim());
                pid_info.put("ppid", line.substring(this.components.get((Object)PPID).begin, this.components.get((Object)PPID).end).trim());
                pid_info.put("%mem", "");
                pid_info.put("%cpu", "");
                pid_info.put("user", "");
                pids.put(Integer.parseInt((String)pid_info.get("pid")), pid_info);
            }
        }
    }

    @Override
    public String getPsDetectionCommand() {
        return "wmic PROCESS get CommandLine,ParentProcessId,ProcessId,WorkingSetSize";
    }

    @Override
    public void generateStackTrace(int pid, String command) {
        if (command.contains("java")) {
            log.info((Object)("getting stack trace for java command: " + command));
            super.executeCommand("jstack " + pid, true);
        }
    }

    @Override
    public String getGentleKillCmd(String pid) {
        return "taskkill /PID " + pid;
    }

    @Override
    public String getRudeKillCmd(String pid) {
        return "taskkill /F /PID " + pid;
    }

    private static class Limits {
        public int begin;
        public int end;

        Limits(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }
    }
}

