/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.remoting;

import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.thoughtworks.xstream.XStream;
import io.atlassian.util.concurrent.Lazy;
import java.util.function.Supplier;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.jetbrains.annotations.NotNull;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class SpringRemotingMessageConverter
implements MessageConverter {
    private final XStreamFactory marshallingXStreamFactory;
    private final XStreamFactory unmarshallingXStreamFactory;
    private final Supplier<XStream> marshallingXStream = Lazy.supplier((Supplier)new Supplier<XStream>(){

        @Override
        public XStream get() {
            return SpringRemotingMessageConverter.this.marshallingXStreamFactory.createXStream();
        }
    });
    private final Supplier<XStream> unmarshallingXStream = Lazy.supplier((Supplier)new Supplier<XStream>(){

        @Override
        public XStream get() {
            return SpringRemotingMessageConverter.this.unmarshallingXStreamFactory.createXStream();
        }
    });

    public SpringRemotingMessageConverter(@NotNull XStreamFactory marshallingXStreamFactory, @NotNull XStreamFactory unmarshallingXStreamFactory) {
        this.marshallingXStreamFactory = marshallingXStreamFactory;
        this.unmarshallingXStreamFactory = unmarshallingXStreamFactory;
    }

    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        String xml = this.toXML(object);
        return session.createTextMessage(xml);
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        if (message == null) {
            throw new JMSException("A timeout has occurred during a remote call to the server.");
        }
        String xml = ((TextMessage)message).getText();
        return this.fromXML(xml);
    }

    private Object fromXML(String xml) {
        return this.unmarshallingXStream.get().fromXML(xml);
    }

    private String toXML(Object object) {
        return this.marshallingXStream.get().toXML(object);
    }
}

