/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.crypto.BouncyCastleProviderUtils;
import com.atlassian.bamboo.security.KeyStoreFactory;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.BambooLogUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.security.random.SecureRandomFactory;
import com.atlassian.utils.process.IOUtils;
import com.google.common.base.Stopwatch;
import io.atlassian.util.concurrent.Lazy;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDSAContentSignerBuilder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BCKeyStoreFactory
implements KeyStoreFactory {
    private static final Logger log = Logger.getLogger(BCKeyStoreFactory.class);
    private static final String KEY_ALGORITH_NAME = "RSA";
    private static final int KEY_SIZE = (int)SystemProperty.EC2_TUNNEL_KEY_LENGTH.getTypedValue();
    private static final String SIGNATURE_ALGORITHM_NAME = "SHA256WITHRSAENCRYPTION";
    private static final int CERTIFICATE_VALIDITY_YEARS = 20;
    private final Supplier<KeyPairGenerator> KEY_PAIR_GENERATOR = Lazy.supplier(() -> {
        KeyPairGenerator gen;
        try {
            gen = KeyPairGenerator.getInstance(KEY_ALGORITH_NAME, BouncyCastleProviderUtils.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        gen.initialize(KEY_SIZE, SecureRandomFactory.newInstance());
        return gen;
    });

    @Override
    @NotNull
    public KeyStore generateKeyStore(String keyAlias, @NotNull String commonName, @Nullable char[] keystorePassword, @NotNull char[] keyPassword) throws KeyStoreException, CertificateException {
        KeyStore store = this.newKeyStore(keystorePassword);
        KeyPairGenerator keyPairGenerator = this.KEY_PAIR_GENERATOR.get();
        Stopwatch stopWatch = Stopwatch.createStarted();
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        BambooLogUtils.logOperationTime((Logger)log, (Stopwatch)stopWatch, (int)1, (int)5, (int)30, (String)"Key pair generation");
        Certificate certificate = BCKeyStoreFactory.createCertificate(commonName, keyPair);
        Certificate[] chain = new Certificate[]{certificate};
        store.setKeyEntry(keyAlias, keyPair.getPrivate(), keyPassword, chain);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public KeyStore loadKeyStore(@NotNull File file, @NotNull char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            keyStore.load(stream, password);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)stream);
        return keyStore;
    }

    @NotNull
    private KeyStore newKeyStore(char[] keystorePassword) throws KeyStoreException {
        KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            store.load(null, keystorePassword);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialise keystore", e);
        }
        return store;
    }

    private static Certificate createCertificate(String cn, KeyPair keyPair) throws CertificateException {
        ContentSigner contentSigner;
        X500Name issuerAndOwner = BCKeyStoreFactory.getCn(cn);
        SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
        Date validTill = DateUtils.addYears((Date)new Date(), (int)20);
        X509v3CertificateBuilder certGenBuilder = new X509v3CertificateBuilder(issuerAndOwner, BCKeyStoreFactory.getSerialNumber(), new Date(), validTill, issuerAndOwner, subPubKeyInfo);
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(SIGNATURE_ALGORITHM_NAME);
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        try {
            AsymmetricKeyParameter keyParameters = BouncyCastleProviderUtils.getKeyParameters((PrivateKey)keyPair.getPrivate());
            contentSigner = keyParameters instanceof RSAKeyParameters ? new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(keyParameters) : new BcDSAContentSignerBuilder(sigAlgId, digAlgId).build(keyParameters);
        }
        catch (OperatorCreationException e) {
            throw new IllegalArgumentException("Invalid digest algorithm", e);
        }
        X509CertificateHolder certHolder = certGenBuilder.build(contentSigner);
        return BCKeyStoreFactory.toCertificate(certHolder);
    }

    private static X500Name getCn(String cn) {
        ASN1ObjectIdentifier commonNameOid = BCStyle.CN;
        RDN[] rdns = new RDN[]{new RDN(commonNameOid, BCStyle.INSTANCE.stringToValue(commonNameOid, cn))};
        return new X500Name(rdns);
    }

    private static BigInteger getSerialNumber() {
        return BigInteger.valueOf(System.nanoTime());
    }

    private static CertificateFactory getX509CertificateFactory() throws CertificateException {
        return CertificateFactory.getInstance("X.509", BouncyCastleProviderUtils.getProvider());
    }

    private static Certificate toCertificate(X509CertificateHolder certHolder) throws CertificateException {
        ByteArrayInputStream is;
        try {
            is = new ByteArrayInputStream(certHolder.getEncoded());
        }
        catch (IOException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
        return BCKeyStoreFactory.getX509CertificateFactory().generateCertificate(is);
    }
}

