/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.security.KeyStoreFactory;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.secrets.api.SecretStore;
import com.atlassian.security.random.SecureRandomFactory;
import io.atlassian.util.concurrent.Lazy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.activemq.broker.SslContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JmsSslManagementUtils {
    private static final Logger log = Logger.getLogger(JmsSslManagementUtils.class);
    public static final String BROKER_KEYSTORE = "broker.ks";
    public static final String BROKER_KEY_ALIAS = "jmsbrokerkey";
    private static final String AGENT_KEY_ALIAS = "jmsclientkey";
    private static final Supplier<SecretStore> secretStore = Lazy.supplier(() -> {
        try {
            Class<?> secretStoreClass = Class.forName(SystemProperty.BAMBOO_JMS_SSL_CIPHER.getValue("com.atlassian.secrets.store.base64.Base64SecretStore"));
            return (SecretStore)secretStoreClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    });

    @NotNull
    public static KeyStore getBrokerKeyStore(KeyStoreFactory keyStoreFactory, char[] keystoreAndKeyPassword) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        File file = FileUtils.getFile((File)SystemDirectory.getConfigDirectory(), (String[])new String[]{BROKER_KEYSTORE});
        return JmsSslManagementUtils.getKeyStore(file, keyStoreFactory, BROKER_KEY_ALIAS, "Bamboo ActiveMQ Broker", keystoreAndKeyPassword);
    }

    @NotNull
    public static KeyStore getClientKeyStore(File file, KeyStoreFactory keyStoreFactory, char[] keystoreAndKeyPassword) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        return JmsSslManagementUtils.getKeyStore(file, keyStoreFactory, AGENT_KEY_ALIAS, "Bamboo ActiveMQ Client", keystoreAndKeyPassword);
    }

    @NotNull
    public static KeyStore getBrokerKeyStore(KeyStoreFactory keyStoreFactory) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        File file = FileUtils.getFile((String[])new String[]{SystemProperty.BAMBOO_JMS_SSL_KEYSTORE.getValue()});
        if (!file.exists()) {
            throw new IllegalStateException("Keystore " + file.getAbsolutePath() + " not found");
        }
        return JmsSslManagementUtils.getKeyStore(file, keyStoreFactory, BROKER_KEY_ALIAS, "Bamboo ActiveMQ Broker", JmsSslManagementUtils.decodePassword(SystemProperty.BAMBOO_JMS_SSL_KEYSTORE_PASSWORD.getValue("")).toCharArray());
    }

    public static String decodePassword(String encryptedValue) {
        if (StringUtils.isNotBlank((CharSequence)encryptedValue)) {
            return secretStore.get().get(encryptedValue);
        }
        return encryptedValue;
    }

    @NotNull
    private static KeyStore getKeyStore(File keyStoreFile, KeyStoreFactory keyStoreFactory, String brokerKeyAlias, String commonName, char[] keystoreAndKeyPassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore;
        if (keyStoreFile.exists()) {
            log.info((Object)("Loading an existing key store from " + keyStoreFile));
            keyStore = keyStoreFactory.loadKeyStore(keyStoreFile, keystoreAndKeyPassword);
            log.info((Object)"Keystore successfully loaded");
        } else {
            log.info((Object)"Generating a new key store...");
            keyStore = keyStoreFactory.generateKeyStore(brokerKeyAlias, commonName, keystoreAndKeyPassword, keystoreAndKeyPassword);
            log.info((Object)"Saving key store for future use...");
            try (OutputStream fos = Files.newOutputStream(keyStoreFile.toPath(), new OpenOption[0]);){
                keyStore.store(fos, keystoreAndKeyPassword);
            }
        }
        return keyStore;
    }

    @NotNull
    public static SslContext newSslContext(KeyStore keyStore, char[] keyStorePassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword);
        trustManagerFactory.init(keyStore);
        return new SslContext(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), SecureRandomFactory.newInstance());
    }

    public static boolean isJmsKeystoreAutomaticManagementDisabled() {
        boolean hasJdkCustomKeyStore;
        return !SystemProperty.BAMBOO_MANAGED_JMS_SSL.getTypedValue() && (hasJdkCustomKeyStore = StringUtils.isNotBlank((CharSequence)System.getProperty("javax.net.ssl.keyStore")));
    }

    public static Certificate getBrokerCertificate(KeyStore keyStore) throws KeyStoreException {
        return keyStore.getCertificate(BROKER_KEY_ALIAS);
    }

    public static void createTrustStore(File trustStoreFile, Certificate certificate) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustStore.setCertificateEntry("broker", certificate);
        try (FileOutputStream fileOutputStream = new FileOutputStream(trustStoreFile);){
            trustStore.store(fileOutputStream, ArrayUtils.EMPTY_CHAR_ARRAY);
        }
    }
}

