/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.shell;

import com.atlassian.bamboo.shell.StreamHandlers;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.log4j.Logger;

public class ShellSession {
    private static final Logger log = Logger.getLogger(ShellSession.class);
    private final StreamHandlers.LineInputHandler input;
    private final ExternalProcess shellProcess;
    private final Thread careTakerThread;
    private final Consumer<String> stdErrHandler;
    private final Thread shellProcessLauncherThread;

    public ShellSession(long sessionId, Consumer<String> stdOutHandler, Consumer<String> stdErrHandler, Thread careTakerThread) {
        this.careTakerThread = careTakerThread;
        this.stdErrHandler = stdErrHandler;
        log.info((Object)("Creating shell session #" + Long.toHexString(sessionId)));
        CountDownLatch pumpsReady = new CountDownLatch(3);
        StreamHandlers.LineOutputHandler output = new StreamHandlers.LineOutputHandler(stdOutHandler, pumpsReady);
        StreamHandlers.LineOutputHandler error = new StreamHandlers.LineOutputHandler(stdErrHandler, pumpsReady);
        this.input = new StreamHandlers.LineInputHandler(pumpsReady);
        ExternalProcessBuilder epb = new ExternalProcessBuilder().command((List)Lists.newArrayList((Object[])new String[]{"/bin/bash"})).handlers((InputHandler)this.input, (OutputHandler)output, (OutputHandler)error);
        this.shellProcess = epb.build();
        this.shellProcessLauncherThread = new Thread("Shell Session #" + Long.toHexString(sessionId)){

            @Override
            public void run() {
                ShellSession.this.shellProcess.execute();
            }
        };
    }

    public void startProcess() {
        this.shellProcessLauncherThread.start();
    }

    public void destroyProcess() {
        this.stdErrHandler.accept("Your session has idled out.");
        this.careTakerThread.interrupt();
        this.shellProcess.cancel();
    }

    public void execute(String command) throws IOException, InterruptedException {
        log.info((Object)("Executing: " + command));
        this.input.submit(command);
        log.info((Object)"Command executed");
    }
}

