/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.shell;

import com.atlassian.bamboo.expirables.ExpiryHandler;
import com.atlassian.bamboo.expirables.ExpiryTicker;
import com.atlassian.bamboo.shell.ShellSession;
import com.atlassian.bamboo.utils.expirables.GuavaCacheLazyExpiryHandler;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class ShellSessionManager {
    private static final Logger log = Logger.getLogger(ShellSessionManager.class);
    private static final int SESSION_EXPIRATION_MINUTES = 1;
    private final CacheLoader<Long, ShellSession> SHELL_SESSION_CREATE = new CacheLoader<Long, ShellSession>(){

        public ShellSession load(@NotNull Long sessionId) throws Exception {
            return ShellSessionManager.this.newShellSession(sessionId);
        }
    };
    private static final RemovalListener<Long, ShellSession> REMOVAL_LISTENER = notification -> {
        log.info((Object)("Destroying shell session: #" + Long.toHexString((Long)notification.getKey()) + " cause: " + notification.getCause()));
        ShellSession shellSession = (ShellSession)notification.getValue();
        assert (shellSession != null);
        shellSession.destroyProcess();
    };
    private final LoadingCache<Long, ShellSession> shellSessionsCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).removalListener(REMOVAL_LISTENER).build(this.SHELL_SESSION_CREATE);

    protected abstract ShellSession newShellSession(long var1);

    protected ShellSessionManager(ExpiryTicker expiryTicker) {
        expiryTicker.register((ExpiryHandler)new GuavaCacheLazyExpiryHandler(this.shellSessionsCache));
    }

    public ShellSession getSession(long sessionId) {
        return (ShellSession)this.shellSessionsCache.getUnchecked((Object)sessionId);
    }

    public void removeSession(long sessionId) {
        this.shellSessionsCache.invalidate((Object)sessionId);
    }
}

