/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.shell;

import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.Watchdog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.commons.io.LineIterator;
import org.apache.log4j.Logger;

final class StreamHandlers {
    private static final Logger log = Logger.getLogger(StreamHandlers.class);

    private StreamHandlers() {
    }

    public static class LineInputHandler
    implements InputHandler {
        private volatile OutputStream bos;
        private final CountDownLatch pumpsReady;

        LineInputHandler(CountDownLatch pumpsReady) {
            this.pumpsReady = pumpsReady;
        }

        public void complete() {
        }

        public void process(OutputStream input) {
            this.bos = input;
            this.pumpsReady.countDown();
        }

        public void setWatchdog(Watchdog watchdog) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submit(String line) throws IOException, InterruptedException {
            this.pumpsReady.await();
            byte[] bytes = line.getBytes();
            OutputStream outputStream = this.bos;
            synchronized (outputStream) {
                this.bos.write(bytes);
                this.bos.write(10);
                this.bos.flush();
            }
        }
    }

    public static class LineOutputHandler
    implements OutputHandler {
        private final Consumer<String> lineHandler;
        private final CountDownLatch pumpsReady;

        LineOutputHandler(Consumer<String> lineHandler, CountDownLatch pumpsReady) {
            this.lineHandler = lineHandler;
            this.pumpsReady = pumpsReady;
        }

        public void process(InputStream output) {
            try (LineIterator lineIterator = new LineIterator((Reader)new InputStreamReader(output, StandardCharsets.UTF_8));){
                this.pumpsReady.countDown();
                while (lineIterator.hasNext()) {
                    String line = lineIterator.next();
                    this.lineHandler.accept(line);
                }
            }
            catch (IOException e) {
                log.warn((Object)"", (Throwable)e);
            }
        }

        public void complete() {
        }

        public void setWatchdog(Watchdog watchdog) {
        }
    }
}

