/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.shell;

import java.util.concurrent.TimeUnit;

public class TriggerOnIdleAndPeriodicallyThread
extends Thread {
    private final Runnable runnable;
    private final long idleDelay;
    private final long maximumDelay;
    private volatile long idleTimeEnd;
    private volatile long maximumDeadlineEnd;

    public TriggerOnIdleAndPeriodicallyThread(Runnable runnable, int n, TimeUnit timeUnit) {
        super("TriggerOnIdle");
        this.setDaemon(true);
        this.runnable = runnable;
        this.idleDelay = timeUnit.toNanos(n);
        this.maximumDelay = TimeUnit.MILLISECONDS.toNanos(500L);
    }

    public void tickle() {
        this.idleTimeEnd = Math.min(System.nanoTime() + this.idleDelay, this.maximumDeadlineEnd);
    }

    private void resetDeadline() {
        this.maximumDeadlineEnd = System.nanoTime() + this.maximumDelay;
    }

    @Override
    public synchronized void start() {
        super.start();
        this.tickle();
        this.resetDeadline();
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            long toSleep = this.idleTimeEnd - System.nanoTime();
            if (toSleep < 0L) {
                this.onIdle();
                this.tickle();
                this.resetDeadline();
                continue;
            }
            this.sleepNanos(toSleep);
        }
    }

    private void sleepNanos(long toSleep) {
        try {
            Thread.sleep(TimeUnit.NANOSECONDS.toMillis(toSleep), (int)(toSleep % 1000000L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void onIdle() {
        this.runnable.run();
    }
}

