/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.spring;

import com.atlassian.bamboo.util.BambooSpringUtils;
import com.atlassian.spring.container.SpringContainerContext;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;

public class BambooSpringContainerContext
extends SpringContainerContext {
    private static final Logger log = Logger.getLogger(BambooSpringContainerContext.class);
    private volatile AutowireCapableBeanFactory beanFactory;

    public Object createComponent(Class clazz) {
        return this.beanFactory.autowire(clazz, 1, false);
    }

    public Object createCompleteComponent(Class clazz) {
        return this.beanFactory.createBean(clazz, 1, false);
    }

    public void autowireComponent(Object bean) {
        if (this.beanFactory != null) {
            BambooSpringUtils.autowireComponent((AutowireCapableBeanFactory)this.beanFactory, (Object)bean);
        } else {
            log.debug((Object)("ApplicationContext is null or has not been set. Cannot proceed with autowiring of component: " + bean));
        }
    }

    public void setApplicationContext(ApplicationContext appContext) throws ApplicationContextException {
        this.beanFactory = appContext != null ? appContext.getAutowireCapableBeanFactory() : null;
        super.setApplicationContext(appContext);
    }
}

