/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.spring;

import com.atlassian.bamboo.amq.AgentJmsUtils;
import com.atlassian.bamboo.setup.ServerFingerprint;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.security.utils.ConstantTimeComparison;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.DestinationDoesNotExistException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.jms.listener.SessionAwareMessageListener;

public class MessageListenerUtils {
    private static final Logger log = Logger.getLogger(MessageListenerUtils.class);

    @NotNull
    public static <M extends Message> SessionAwareMessageListener<M> wrapWithServerFingerprintCheck(ServerFingerprint serverFingerprint, SessionAwareMessageListener<M> messageListener) {
        return (message, session) -> {
            BambooRunnables.Throwing onMessage = () -> messageListener.onMessage(message, session);
            MessageListenerUtils.wrapWithServerFingerprintCheck(serverFingerprint, message, (BambooRunnables.Throwing<JMSException>)onMessage);
        };
    }

    public static <M extends Message> SessionAwareMessageListener<M> wrapWithInstanceFingerprintCheck(ServerFingerprint serverFingerprint, SessionAwareMessageListener<Message> messageListener) {
        return (message, session) -> {
            try {
                Long messageFingerprint = AgentJmsUtils.getInstanceFingerprint(message);
                if (messageFingerprint != null && serverFingerprint.getInstanceFingerprint() == messageFingerprint.longValue()) {
                    messageListener.onMessage(message, session);
                } else {
                    log.debug((Object)"Dropping a message sent before Bamboo server was restarted or sent to a different instance");
                }
            }
            catch (DestinationDoesNotExistException e) {
                MessageListenerUtils.logDestinationDoesNotExist(e);
            }
            catch (JMSException e) {
                log.warn((Object)"", (Throwable)e);
            }
        };
    }

    @NotNull
    public static MessageListener wrapWithServerFingerprintCheck(ServerFingerprint serverFingerprint, MessageListener messageListener) {
        return message -> {
            BambooRunnables.Throwing onMessage = () -> messageListener.onMessage(message);
            MessageListenerUtils.wrapWithServerFingerprintCheck(serverFingerprint, message, (BambooRunnables.Throwing<JMSException>)onMessage);
        };
    }

    private static <M extends Message> void wrapWithServerFingerprintCheck(ServerFingerprint serverFingerprint, M message, BambooRunnables.Throwing<JMSException> runnable) {
        try {
            String messageFingerprint = message.getStringProperty("fingerprint");
            if (messageFingerprint != null && ConstantTimeComparison.isEqual((String)serverFingerprint.getServerFingerprint(), (String)messageFingerprint)) {
                runnable.run();
            } else {
                log.debug((Object)"Dropping a message sent before Bamboo server was restarted or sent to a different instance");
            }
        }
        catch (DestinationDoesNotExistException e) {
            MessageListenerUtils.logDestinationDoesNotExist(e);
        }
        catch (JMSException e) {
            log.warn((Object)"", (Throwable)e);
        }
    }

    private static void logDestinationDoesNotExist(DestinationDoesNotExistException e) {
        log.info((Object)("DestinationDoesNotExistException: " + e.getMessage()));
    }
}

