/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.amq.AgentJmsUtils;
import com.atlassian.bamboo.executor.SystemSecurityContextExecutors;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.v2.build.agent.AgentCommandSender;
import com.atlassian.bamboo.v2.build.agent.messages.JmsSelectorUtils;
import com.atlassian.bamboo.v2.build.agent.messages.RemoteBambooMessage;
import java.util.concurrent.ExecutorService;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.core.support.JmsGatewaySupport;

public class AgentCommandSenderImpl
extends JmsGatewaySupport
implements AgentCommandSender {
    private static final Logger log = LogManager.getLogger(AgentCommandSenderImpl.class);
    private final BootstrapManager bootstrapManager;
    private final ExecutorService executorService;

    public AgentCommandSenderImpl(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
        this.executorService = SystemSecurityContextExecutors.newSingleThreadExecutor((String)"AgentCommandSender");
    }

    @Override
    public void send(RemoteBambooMessage message, final Long buildAgentId) {
        this.executorService.submit(() -> {
            try {
                this.getJmsTemplate().convertAndSend((Object)message, new MessagePostProcessor(){

                    public Message postProcessMessage(Message message) throws JMSException {
                        message.setStringProperty("allowableAgents", JmsSelectorUtils.getAgentsMessageProperty((Long)buildAgentId));
                        AgentJmsUtils.setFingerprint(message, AgentCommandSenderImpl.this.bootstrapManager.getFingerprint());
                        return message;
                    }
                });
            }
            catch (Exception e) {
                log.error("Error sending message to agent", (Throwable)e);
            }
        });
    }
}

