/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.utils.ResultKeyUtils;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class AgentEphemeralityContext {
    private static final Logger log = Logger.getLogger(AgentEphemeralityContext.class);
    private static Boolean isEphemeral;
    private static AtomicReference<ResultKey> resultKey;
    private static AtomicReference<Long> templateId;
    private static AtomicReference<String> podName;

    private AgentEphemeralityContext() {
    }

    public static boolean isEphemeral() {
        if (AgentEphemeralityContext.getEphemeralAgentDedication() != null && AgentEphemeralityContext.getEphemeralAgentTemplateId() != null && AgentEphemeralityContext.getEphemeralAgentPodName() != null) {
            return true;
        }
        if (isEphemeral == null) {
            isEphemeral = AgentTypeHolder.get() == AgentType.EPHEMERAL;
        }
        return isEphemeral;
    }

    @Nullable
    public static ResultKey getEphemeralAgentDedication() {
        if (resultKey == null) {
            String key;
            resultKey = AgentTypeHolder.get() == AgentType.LOCAL ? new AtomicReference<Object>(null) : new AtomicReference<ResultKey>(StringUtils.isNotBlank((CharSequence)(key = System.getProperty("bamboo.agent.ephemeral.for.key"))) ? ResultKeyUtils.toResultKey((String)key) : null);
        }
        return resultKey.get();
    }

    public static boolean hasEphemeralAgentDedication() {
        return AgentEphemeralityContext.getEphemeralAgentDedication() != null;
    }

    @Nullable
    public static Long getEphemeralAgentTemplateId() {
        if (templateId == null) {
            String templateIdProperty;
            templateId = AgentTypeHolder.get() != AgentType.EPHEMERAL ? new AtomicReference<Object>(null) : new AtomicReference<Object>((StringUtils.isNumeric((CharSequence)(templateIdProperty = System.getProperty("bamboo.agent.ephemeral.template.id"))) ? Long.valueOf(Long.parseLong(templateIdProperty)) : null));
        }
        return templateId.get();
    }

    public static String getEphemeralAgentPodName() {
        if (podName == null) {
            podName = AgentTypeHolder.get() != AgentType.EPHEMERAL ? new AtomicReference<Object>(null) : new AtomicReference<String>(System.getProperty("bamboo.agent.ephemeral.pod.name"));
        }
        return podName.get();
    }
}

