/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.amq.BrokerUriUtils;
import com.atlassian.bamboo.crypto.BouncyCastleProviderUtils;
import com.atlassian.bamboo.security.JmsSslManagementUtils;
import com.atlassian.bamboo.security.KeyStoreFactory;
import com.atlassian.bamboo.setup.BambooHomeLocator;
import com.atlassian.bamboo.utils.SystemProperty;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class BambooActiveMQConnectionFactory
extends ActiveMQSslConnectionFactory {
    private static final Logger log = Logger.getLogger(BambooActiveMQConnectionFactory.class);
    public static final String FAILOVER_RECONNECT_PARAMS = "maxReconnectAttempts=10&initialReconnectDelay=15000";
    private static final Set<String> VALIDATED_BROKER_URLS = new ConcurrentSkipListSet<String>();
    @Lazy
    @Autowired
    private KeyStoreFactory keyStoreFactory;
    @Lazy
    @Autowired
    private BambooHomeLocator homeLocator;

    public BambooActiveMQConnectionFactory(String brokerURL) {
        super(brokerURL);
    }

    public void setBrokerURL(String brokerURL) {
        if (VALIDATED_BROKER_URLS.add(brokerURL)) {
            log.info((Object)("Setting broker URL to '" + brokerURL + "'"));
            this.validateUri(brokerURL);
        }
        super.setBrokerURL(brokerURL);
    }

    @PostConstruct
    private void setupSsl() {
        boolean isSslConnection = StringUtils.contains((CharSequence)this.getBrokerURL(), (CharSequence)"ssl://");
        if (!isSslConnection) {
            return;
        }
        if (JmsSslManagementUtils.isJmsKeystoreAutomaticManagementDisabled()) {
            log.info((Object)"Automatic JMS SSL management is disabled");
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)BambooActiveMQConnectionFactory.getBambooJmsSslTruststorePropertyValue())) {
            log.info((Object)"Custom JMS SSL credentials are provided");
            File trustStoreFile = FileUtils.getFile((String[])new String[]{BambooActiveMQConnectionFactory.getBambooJmsSslTruststorePropertyValue()});
            if (!trustStoreFile.exists()) {
                log.info((Object)("Truststore file '" + BambooActiveMQConnectionFactory.getBambooJmsSslTruststorePropertyValue() + "' not found. Skipping truststore initialization"));
                return;
            }
            try {
                this.setTrustStore(trustStoreFile.getAbsolutePath());
                this.setTrustStorePassword(JmsSslManagementUtils.decodePassword(BambooActiveMQConnectionFactory.getBambooJmsSslTruststorePasswordPropertyValue()));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        log.info((Object)"Automatic JMS SSL management is enabled");
        try {
            File trustStoreFile = FileUtils.getFile((String[])new String[]{this.homeLocator.getSharedHomePath(), "configuration", "jmsclient.ts"});
            if (!trustStoreFile.exists()) {
                trustStoreFile.getParentFile().mkdirs();
                Certificate brokerCertificate = this.getBrokerCertificate();
                if (brokerCertificate != null) {
                    JmsSslManagementUtils.createTrustStore(trustStoreFile, brokerCertificate);
                }
            }
            this.setTrustStore(trustStoreFile.getAbsolutePath());
            this.setTrustStorePassword("");
        }
        catch (Exception e) {
            log.warn((Object)"Unable to automatically manage SSL keys: ", (Throwable)e);
        }
    }

    @NotNull
    private static String getBambooJmsSslTruststorePasswordPropertyValue() {
        return SystemProperty.BAMBOO_JMS_SSL_TRUSTSTORE_PASSWORD.getValue(new SystemProperty(false, new String[]{SystemProperty.BAMBOO_JMS_SSL_TRUSTSTORE_PASSWORD.getKey().toLowerCase()}).getValue(""));
    }

    @NotNull
    private static String getBambooJmsSslTruststorePropertyValue() {
        return SystemProperty.BAMBOO_JMS_SSL_TRUSTSTORE.getValue(new SystemProperty(false, new String[]{SystemProperty.BAMBOO_JMS_SSL_TRUSTSTORE.getKey().toLowerCase()}).getValue(""));
    }

    private Certificate getBrokerCertificate() throws CertificateException {
        String base64Certificate = new SystemProperty(false, new String[]{"bamboo.agent.brokerCertificate"}).getValue();
        if (base64Certificate == null) {
            log.warn((Object)"Broker certificate not found");
            return null;
        }
        return BambooActiveMQConnectionFactory.toJavaCertificate(Base64.getUrlDecoder().decode(base64Certificate));
    }

    private static Certificate toJavaCertificate(byte[] certHolder) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", BouncyCastleProviderUtils.getProvider());
        ByteArrayInputStream is = new ByteArrayInputStream(certHolder);
        return certificateFactory.generateCertificate(is);
    }

    private void validateUri(String brokerURL) {
        try {
            URI compositeUri = URI.create(brokerURL);
            List<URI> simpleUris = BrokerUriUtils.getSimpleUris(compositeUri);
            for (URI simpleUri : simpleUris) {
                if (simpleUri.getScheme().equals("vm")) continue;
                String errorMessage = BambooActiveMQConnectionFactory.ping(simpleUri);
                if (errorMessage != null) {
                    log.warn((Object)("Broker URI: " + simpleUri + " is invalid: " + errorMessage));
                    continue;
                }
                log.info((Object)("Broker URI: " + simpleUri + " is valid."));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to validate " + brokerURL + ": " + e));
        }
    }

    @Nullable
    private static String ping(URI uri) {
        String string;
        Socket socket = new Socket();
        try {
            int timeout = (int)TimeUnit.SECONDS.toMillis(1L);
            socket.setSoTimeout(timeout);
            InetSocketAddress socketAddress = new InetSocketAddress(uri.getHost(), uri.getPort());
            socket.connect(socketAddress, timeout);
            socket.getInputStream();
            string = null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return e.toString();
            }
        }
        socket.close();
        return string;
    }
}

