/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.amq.BambooBrokerService;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.bamboo.v2.build.agent.BambooAgentMessageDeliverer;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.Usage;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.jms.support.converter.MessageConverter;

public class BambooAgentMessageListener
extends BambooAgentMessageDeliverer
implements MessageListener {
    private static final Logger log = Logger.getLogger(BambooAgentMessageListener.class);
    private static final long DEFAULT_LONG_PROCESSING_THRESHOLD = TimeUnit.SECONDS.toMillis(2L);
    private static final long DEFAULT_VERY_LONG_PROCESSING_THRESHOLD = 10L * DEFAULT_LONG_PROCESSING_THRESHOLD;
    private long longProcessingThresholdMillis = DEFAULT_LONG_PROCESSING_THRESHOLD;
    private long veryLongProcessingThresholdMillis = DEFAULT_VERY_LONG_PROCESSING_THRESHOLD;
    private final MessageConverter messageConverter;
    private final BambooBrokerService brokerService;
    private static long USAGE_STATS_LAST_CHECKED = 0L;
    private static final int USAGE_STATS_LOGGING_THRESHOLD = 30000000;

    public BambooAgentMessageListener(MessageConverter messageConverter, BambooBrokerService brokerService) {
        this.messageConverter = messageConverter;
        this.brokerService = brokerService;
    }

    public void onMessage(final Message message) {
        this.printStats();
        final long deliveryTime = System.currentTimeMillis();
        ImpersonationHelper.runWithSystemAuthority((BambooRunnables.ThrowingX)new BambooRunnables.NotThrowing(){

            public void run() {
                Object object;
                if (log.isDebugEnabled()) {
                    BambooAgentMessageListener.this.logDelivery(message, deliveryTime);
                }
                if ((object = BambooAgentMessageListener.this.decode(message)) != null) {
                    BambooAgentMessageListener.this.deliverObject(object);
                    BambooAgentMessageListener.this.logProcessingDuration(object, deliveryTime);
                }
            }
        });
    }

    private void printStats() {
        if (this.brokerService == null) {
            return;
        }
        if (System.currentTimeMillis() - USAGE_STATS_LAST_CHECKED > 5000L) {
            SystemUsage systemUsage = this.brokerService.getSystemUsage();
            this.logUsage("Memory", (Usage)systemUsage.getMemoryUsage());
            this.logUsage("Store", (Usage)systemUsage.getStoreUsage());
            this.logUsage("Temp", (Usage)systemUsage.getTempUsage());
            USAGE_STATS_LAST_CHECKED = System.currentTimeMillis();
        }
    }

    private <T extends Usage> void logUsage(String storeName, Usage<T> usage) {
        long usageInBytes = usage.getUsage();
        if (usageInBytes > 30000000L) {
            log.info((Object)(storeName + " Usage: " + usage.getPercentUsage() + "% " + FileUtils.byteCountToDisplaySize((long)usageInBytes)));
        }
    }

    private Object decode(Message message) {
        try {
            return this.messageConverter.fromMessage(message);
        }
        catch (JMSException exception) {
            log.error((Object)("Unable to decode message: " + message), (Throwable)exception);
            return null;
        }
    }

    private void logProcessingDuration(Object object, long deliveryTime) {
        long processingDuration = System.currentTimeMillis() - deliveryTime;
        String typeMessage = "The message is of type " + object.getClass().getSimpleName() + ", content " + object;
        if (processingDuration > this.longProcessingThresholdMillis) {
            if (processingDuration > this.veryLongProcessingThresholdMillis) {
                log.warn((Object)("Processing of message took " + processingDuration + "ms, which is very long, this is a risk to system stability." + typeMessage));
            } else {
                log.info((Object)("Processing of message took " + processingDuration + "ms, which may be too long. " + typeMessage));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Processing of message took " + processingDuration + "ms. " + typeMessage));
        }
    }

    private void logDelivery(Message message, long deliveryTime) {
        long msgSubmissionTime = 0L;
        try {
            msgSubmissionTime = message.getJMSTimestamp();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        long deliveryDuration = deliveryTime - msgSubmissionTime;
        long msgSize = -1L;
        if (message instanceof MessageReference) {
            MessageReference messageReference = (MessageReference)message;
            msgSize = messageReference.getSize();
        }
        log.debug((Object)("received message, delivery duration: " + deliveryDuration + "ms, message size: " + msgSize));
    }

    public void setLongProcessingThresholdSeconds(long longProcessingThresholdSeconds) {
        this.longProcessingThresholdMillis = TimeUnit.SECONDS.toMillis(longProcessingThresholdSeconds);
    }

    public void setVeryLongProcessingThresholdSeconds(long veryLongProcessingThresholdSeconds) {
        this.veryLongProcessingThresholdMillis = TimeUnit.SECONDS.toMillis(veryLongProcessingThresholdSeconds);
    }
}

