/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.google.common.base.Preconditions;
import javax.annotation.PostConstruct;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.jetbrains.annotations.Nullable;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class BambooJmsTemplate
extends JmsTemplate {
    public BambooJmsTemplate(ConnectionFactory connectionFactory, MessageConverter messageConverter) {
        super(connectionFactory);
        this.setMessageConverter(messageConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Message doReceive(Session session, MessageConsumer consumer) throws JMSException {
        boolean isJtaTransaction;
        Message message;
        try {
            Message message2;
            long timeout = this.getReceiveTimeout();
            JmsResourceHolder resourceHolder = (JmsResourceHolder)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory());
            if (resourceHolder != null && resourceHolder.hasTimeout()) {
                timeout = resourceHolder.getTimeToLiveInMillis();
            }
            Message message3 = message2 = timeout >= 0L ? consumer.receive(timeout) : consumer.receive();
            if (session.getTransacted()) {
                if (this.isSessionLocallyTransacted(session)) {
                    JmsUtils.commitIfNecessary((Session)session);
                }
            } else if (this.isClientAcknowledge(session) && message2 != null) {
                message2.acknowledge();
            }
            message = message2;
        }
        catch (Throwable throwable) {
            boolean isJtaTransaction2;
            boolean wasInterrupted = Thread.interrupted();
            JmsUtils.closeMessageConsumer((MessageConsumer)consumer);
            boolean bl = isJtaTransaction2 = session.getTransacted() && !this.isSessionLocallyTransacted(session);
            if (wasInterrupted && !isJtaTransaction2) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        boolean wasInterrupted = Thread.interrupted();
        JmsUtils.closeMessageConsumer((MessageConsumer)consumer);
        boolean bl = isJtaTransaction = session.getTransacted() && !this.isSessionLocallyTransacted(session);
        if (wasInterrupted && !isJtaTransaction) {
            Thread.currentThread().interrupt();
        }
        return message;
    }

    @PostConstruct
    private void assertCustomMessageConverterIsUsed() {
        Preconditions.checkState((!(this.getMessageConverter() instanceof SimpleMessageConverter) ? 1 : 0) != 0);
    }
}

