/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.security.random.DefaultSecureRandomService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidImpl;
import org.apache.log4j.Logger;

public class BambooXidFactoryImpl
implements XidFactory {
    private static final Logger log = Logger.getLogger(BambooXidFactoryImpl.class);
    private final byte[] baseId = new byte[64];
    private long count = 1L;

    public BambooXidFactoryImpl(byte[] tmId) {
        System.arraycopy(tmId, 0, this.baseId, 8, tmId.length);
    }

    public BambooXidFactoryImpl() {
        byte[] hostid;
        try {
            hostid = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            hostid = new byte[]{127, 0, 0, 1};
        }
        int uid = System.identityHashCode(this);
        NumberUtils.arrayStore((int)uid, (byte[])this.baseId, (int)8);
        byte[] entropy = new byte[2];
        DefaultSecureRandomService.getInstance().nextBytes(entropy);
        int pos = 12;
        System.arraycopy(entropy, 0, this.baseId, pos, entropy.length);
        System.arraycopy(hostid, 0, this.baseId, pos += entropy.length, hostid.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid createXid() {
        long id;
        byte[] globalId = (byte[])this.baseId.clone();
        BambooXidFactoryImpl bambooXidFactoryImpl = this;
        synchronized (bambooXidFactoryImpl) {
            id = this.count++;
        }
        NumberUtils.arrayStore((long)id, (byte[])globalId, (int)0);
        return new XidImpl(globalId);
    }

    public Xid createBranch(Xid globalId, int branch) {
        byte[] branchId = (byte[])this.baseId.clone();
        NumberUtils.arrayStore((int)branch, (byte[])branchId, (int)0);
        return new XidImpl(globalId, branchId);
    }

    public boolean matchesGlobalId(byte[] globalTransactionId) {
        if (globalTransactionId.length != 64) {
            return false;
        }
        for (int i = 8; i < globalTransactionId.length; ++i) {
            if (globalTransactionId[i] == this.baseId[i]) continue;
            return false;
        }
        return true;
    }

    public boolean matchesBranchId(byte[] branchQualifier) {
        if (branchQualifier.length != 64) {
            return false;
        }
        for (int i = 8; i < branchQualifier.length; ++i) {
            if (branchQualifier[i] == this.baseId[i]) continue;
            return false;
        }
        return true;
    }

    public Xid recover(int formatId, byte[] globalTransactionid, byte[] branchQualifier) {
        return new XidImpl(formatId, globalTransactionid, branchQualifier);
    }
}

