/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.BuildLoggingContext;
import com.atlassian.bamboo.build.logger.LogMutator;
import com.atlassian.bamboo.build.logger.interceptors.PasswordMaskingLogMutator;
import com.atlassian.bamboo.build.warning.BuildWarningSummaryCollationService;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.execution.ExecutionPhaseService;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.persister.xstream.SecureXStreamFactory;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.AgentEphemeralityContext;
import com.atlassian.bamboo.v2.build.agent.BuildAgentController;
import com.atlassian.bamboo.v2.build.agent.DefaultBuildAgent;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.ResultProcessor;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RemotedCapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.docker.DockerContainerController;
import com.atlassian.bamboo.v2.build.agent.docker.DockerContainerControllerFactory;
import com.atlassian.bamboo.v2.build.events.ExecutableQueueUpdate;
import com.atlassian.bamboo.v2.build.queue.AgentQueueAccessor;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;

public class BuildAgentControllerImpl
implements BuildAgentController {
    private static final Logger log = Logger.getLogger(BuildAgentControllerImpl.class);
    private static final long FAILSAFE_WAIT_DURATION = TimeUnit.MINUTES.toMillis(5L);
    private static final String RESULT_FILE_NAME = "build-result.xml";
    private final AgentContext agentContext;
    private final AgentQueueAccessor agentQueueAccessor;
    private final BuildLoggerManager buildLoggerManager;
    private final ResultProcessor resultProcessor;
    private final CapabilityContext capabilityContext;
    private final RemotedCapabilitySetManager capabilitySetManager;
    private final CustomVariableContext customVariableContext;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final ExecutionPhaseService executionPhaseService;
    private final EventPublisher eventPublisher;
    private final AtomicLong eventCounter = new AtomicLong();
    private final DockerContainerControllerFactory dockerContainerControllerFactory;
    private final BuildWarningSummaryCollationService buildWarningSummaryCollationService;
    private final BuildLoggingContext buildLoggingContext;
    private final SecureXStreamFactory secureXStreamFactory;
    private final BuildDirectoryManager buildDirectoryManager;
    private final ArtifactManager artifactManager;

    public BuildAgentControllerImpl(AgentContext agentContext, AgentQueueAccessor agentQueueAccessor, BuildLoggerManager buildLoggerManager, ResultProcessor resultProcessor, CapabilityContext capabilityContext, RemotedCapabilitySetManager capabilitySetManager, CustomVariableContext customVariableContext, ErrorUpdateHandler errorUpdateHandler, ExecutionPhaseService executionPhaseService, EventPublisher eventPublisher, DockerContainerControllerFactory dockerContainerControllerFactory, BuildWarningSummaryCollationService buildWarningSummaryCollationService, BuildLoggingContext buildLoggingContext, @Qualifier(value="remoteCommunicationSecuredXStreamFactory") SecureXStreamFactory secureXStreamFactory, BuildDirectoryManager buildDirectoryManager, ArtifactManager artifactManager) {
        this.agentContext = agentContext;
        this.agentQueueAccessor = agentQueueAccessor;
        this.buildLoggerManager = buildLoggerManager;
        this.resultProcessor = resultProcessor;
        this.capabilityContext = capabilityContext;
        this.capabilitySetManager = capabilitySetManager;
        this.customVariableContext = customVariableContext;
        this.errorUpdateHandler = errorUpdateHandler;
        this.executionPhaseService = executionPhaseService;
        this.eventPublisher = eventPublisher;
        this.dockerContainerControllerFactory = dockerContainerControllerFactory;
        this.buildWarningSummaryCollationService = buildWarningSummaryCollationService;
        this.buildLoggingContext = buildLoggingContext;
        this.secureXStreamFactory = secureXStreamFactory;
        this.buildDirectoryManager = buildDirectoryManager;
        this.artifactManager = artifactManager;
    }

    @PostConstruct
    private void postConstruct() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    private void preDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    public void prepareForBuilding(@NotNull ExecutableBuildAgent buildAgent) {
        this.agentContext.setBuildAgent(buildAgent);
    }

    public void finishBuilding(@NotNull ExecutableBuildAgent buildAgent) {
        this.agentContext.clearBuildAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndPerformBuild(@NotNull ExecutableBuildAgent buildAgent) {
        try {
            log.info((Object)("Agent '" + buildAgent.getName() + "' ready to take build from queue..."));
            CommonContext context = this.getContextFromQueue(buildAgent);
            buildAgent.onContextReceived(context);
            try {
                this.executionPhaseService.agentAssigned(context, buildAgent.getId());
                buildAgent.resetErrors();
                buildAgent.setContextToBuild(context);
                BuildLogger buildLogger = this.buildLoggerManager.getLogger(context.getResultKey());
                this.buildLoggingContext.setContext(context, buildLogger);
                try {
                    ReadOnlyCapabilitySet agentCapabilities = this.capabilitySetManager.getCombinedCapabilitySet(buildAgent.getId());
                    Preconditions.checkState((agentCapabilities != null ? 1 : 0) != 0, (Object)"Cannot access the capabilities for the agent.");
                    this.capabilityContext.setCapabilitySet(agentCapabilities);
                    VariableSubstitutor substitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForCommonContext(context);
                    this.customVariableContext.withVariableSubstitutor(substitutor, () -> {
                        try (DockerContainerController dockerContainerController = this.dockerContainerControllerFactory.forCommonContext(context);
                             BuildWarningsFileController buildWarningsFileController = new BuildWarningsFileController(this.buildWarningSummaryCollationService, context);){
                            buildLogger.getMutatorStack().add((LogMutator)new PasswordMaskingLogMutator(context.getVariableContext()));
                            log.info((Object)buildLogger.addBuildLogEntry("Build " + context.getDisplayName() + " is being prepared for building on agent " + buildAgent.getName() + ", bamboo version: " + BuildUtils.getCurrentVersion()));
                            log.info((Object)buildLogger.addBuildLogEntry(buildAgent.getDescription()));
                            buildAgent.build(agentCapabilities, dockerContainerController);
                        }
                        finally {
                            context.getVariableContext().getSubstitutions().putAll(this.customVariableContext.getSubstitutedVariables());
                        }
                        return null;
                    });
                }
                catch (Exception e) {
                    String errorMessage = "Error occurred while executing the build for " + context.getDisplayName();
                    log.error((Object)errorMessage, (Throwable)e);
                    this.errorUpdateHandler.recordError(context.getResultKey(), errorMessage, (Throwable)e);
                    log.warn((Object)context.getErrorCollection().addErrorMessage(errorMessage, e));
                    this.failBuildIfNeeded(context);
                }
                finally {
                    this.capabilityContext.clearCapabilitySet();
                    this.buildLoggingContext.clearContext();
                    buildLogger.getMutatorStack().clear();
                    this.buildLoggerManager.transferLogs(buildLogger, context);
                }
                this.processResult(buildAgent, context);
            }
            catch (Throwable exception) {
                try {
                    String errorMessage = "Unknown error occurred on '" + buildAgent.getName() + "' when building " + context.getDisplayName() + ". Agent will attempt process the build result...";
                    log.error((Object)errorMessage, exception);
                    this.errorUpdateHandler.recordError(context.getResultKey(), errorMessage, exception);
                    this.failBuildIfNeeded(context);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.processResult(buildAgent, context);
                }
            }
        }
        catch (InterruptedException e) {
            DefaultBuildAgent.MainAgentThread mainAgentThread = (DefaultBuildAgent.MainAgentThread)Thread.currentThread();
            if (mainAgentThread.isStopFlagRaised()) {
                log.warn((Object)("Agent main thread interrupted. Stopping agent '" + buildAgent.getName() + "'..."));
                buildAgent.stop();
            } else {
                log.info((Object)"Building interrupted.");
            }
        }
        catch (Exception e) {
            String errorMessage = "Unknown exception occurred on '" + buildAgent.getName() + "'. Agent will attempt to recover its normal operation...";
            log.error((Object)errorMessage, (Throwable)e);
            this.errorUpdateHandler.recordError(errorMessage, (Throwable)e);
            buildAgent.incrementError();
        }
        finally {
            buildAgent.onBuildProcessingFinished();
        }
    }

    public boolean hasPreviousBuildResultToSend(ExecutableBuildAgent executableBuildAgent) {
        if (AgentTypeHolder.get() == AgentType.LOCAL) {
            return false;
        }
        File workingDirectory = this.buildDirectoryManager.getBaseBuildWorkingDirectory();
        Path buildResultXml = Paths.get(workingDirectory.getAbsolutePath(), RESULT_FILE_NAME);
        if (!Files.exists(buildResultXml, new LinkOption[0])) {
            return false;
        }
        try {
            return Files.size(buildResultXml) > 0L;
        }
        catch (IOException e) {
            log.warn((Object)"Cannot determine size of the result file. Aborting result restoration", (Throwable)e);
            BambooPathUtils.deleteQuietly((Path)buildResultXml);
            return false;
        }
    }

    public boolean sendPreviousBuildResultIfRequired(ExecutableBuildAgent buildAgent) {
        if (AgentTypeHolder.get() == AgentType.LOCAL) {
            return true;
        }
        File workingDirectory = this.buildDirectoryManager.getBaseBuildWorkingDirectory();
        Path buildResultXml = Paths.get(workingDirectory.getAbsolutePath(), RESULT_FILE_NAME);
        if (Files.exists(buildResultXml, new LinkOption[0])) {
            log.info((Object)"Found a result that requires re-sending....");
            XStream xStream = this.secureXStreamFactory.createXStream();
            CommonContext context = null;
            try {
                context = (CommonContext)xStream.fromXML(buildResultXml.toFile());
            }
            catch (Exception e) {
                log.error((Object)"Error loading build context: abort result restoration", (Throwable)e);
                buildAgent.incrementError();
                BambooPathUtils.deleteQuietly((Path)buildResultXml);
                return true;
            }
            try {
                if (context != null) {
                    return this.retryProcessingResult(buildAgent, context);
                }
            }
            catch (Exception e) {
                log.error(null, (Throwable)e);
                buildAgent.incrementError();
                return false;
            }
        }
        return true;
    }

    private void failBuildIfNeeded(CommonContext context) {
        if (context.getCurrentResult().getBuildState() == BuildState.SUCCESS) {
            log.info((Object)"An exception was propagated but build state was set as successful, forcing failure");
            context.getCurrentResult().setBuildState(BuildState.FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retryProcessingResult(@NotNull ExecutableBuildAgent buildAgent, CommonContext context) {
        try {
            buildAgent.setContextToBuild(context);
            boolean bl = this.processResult(buildAgent, context);
            return bl;
        }
        finally {
            buildAgent.onBuildProcessingFinished();
        }
    }

    private boolean processResult(@NotNull ExecutableBuildAgent buildAgent, CommonContext context) {
        this.dumpContextToFile(context);
        boolean allArtifactTransfersResolved = this.retryArtifactTransferIfNeeded(context);
        if (allArtifactTransfersResolved) {
            this.resultProcessor.processResult(context);
            File workingDirectory = this.buildDirectoryManager.getBaseBuildWorkingDirectory();
            Path buildResultXml = Paths.get(workingDirectory.getAbsolutePath(), RESULT_FILE_NAME);
            BambooPathUtils.deleteQuietly((Path)buildResultXml);
            return true;
        }
        buildAgent.incrementError();
        return false;
    }

    private boolean retryArtifactTransferIfNeeded(@NotNull CommonContext context) {
        if (context.getArtifactContext().getPublishingResults().stream().noneMatch(ArtifactPublishingResult::needsRetry)) {
            log.debug((Object)"No artifacts require retransmission.");
            return true;
        }
        List<ArtifactPublishingResult> resultsWithRepublishState = context.getArtifactContext().getPublishingResults().stream().filter(ArtifactPublishingResult::needsRetry).collect(Collectors.toList());
        ArrayList newResults = new ArrayList();
        context.getArtifactContext().getPublishingResults().removeIf(ArtifactPublishingResult::needsRetry);
        resultsWithRepublishState.forEach(apr -> {
            log.info((Object)("Found artifact that needs upload retry: " + apr.getArtifactDefinitionContext().getName()));
            ArtifactPublishingResult newResult = this.artifactManager.republish(null, context.getResultKey(), apr, BuildContextHelper.getArtifactHandlerConfiguration((CommonContext)context));
            context.getArtifactContext().addPublishingResult(newResult);
            newResults.add(newResult);
        });
        for (ArtifactPublishingResult result : newResults) {
            if (result.shouldContinueBuild() || !(context instanceof BuildContext)) continue;
            ((BuildContext)context).getBuildResult().setBuildState(BuildState.FAILED);
        }
        this.dumpContextToFile(context);
        return newResults.stream().noneMatch(ArtifactPublishingResult::needsRetry);
    }

    private void dumpContextToFile(CommonContext context) {
        if (AgentTypeHolder.get() == AgentType.LOCAL) {
            return;
        }
        XStream xStream = this.secureXStreamFactory.createXStream();
        File workingDirectory = this.buildDirectoryManager.getBaseBuildWorkingDirectory();
        Path buildResultXml = Paths.get(workingDirectory.getAbsolutePath(), RESULT_FILE_NAME);
        try (BufferedWriter out = new BufferedWriter((Writer)new FileWriterWithEncoding(buildResultXml.toFile(), Charset.defaultCharset()));){
            log.info((Object)("Dumping context to file: " + buildResultXml));
            xStream.toXML((Object)context, (Writer)out);
        }
        catch (Exception e) {
            log.error((Object)"Unable to dump context to file.", (Throwable)e);
            BambooPathUtils.deleteQuietly((Path)buildResultXml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CommonContext getContextFromQueue(ExecutableBuildAgent buildAgent) throws InterruptedException {
        while (!Thread.interrupted()) {
            log.info((Object)("Agent " + buildAgent.getId() + " checking build queue for executables..."));
            long eventCount = this.eventCounter.get();
            AgentQueueAccessor.QueueAccessResult queueAccessResult = this.agentQueueAccessor.takeContext(buildAgent.getId(), AgentEphemeralityContext.getEphemeralAgentDedication());
            if (queueAccessResult.getContext() != null) {
                log.info((Object)(queueAccessResult.getContext().getDisplayName() + " taken from queue."));
                return queueAccessResult.getContext();
            }
            if (queueAccessResult.getError() != null) {
                buildAgent.stop();
                throw new IllegalStateException(queueAccessResult.getError());
            }
            if (AgentEphemeralityContext.hasEphemeralAgentDedication() && !queueAccessResult.isTimedOut()) {
                log.info((Object)String.format("Ephemeral agent did not get expected job %s. Agent will stop now", AgentEphemeralityContext.getEphemeralAgentDedication()));
                buildAgent.stopNicely(0);
                break;
            }
            AtomicLong atomicLong = this.eventCounter;
            synchronized (atomicLong) {
                if (this.eventCounter.get() == eventCount && !AgentEphemeralityContext.hasEphemeralAgentDedication()) {
                    log.debug((Object)"No executables on the server, waiting for new ones...");
                    this.eventCounter.wait(FAILSAFE_WAIT_DURATION);
                }
            }
        }
        throw new InterruptedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onEvent(ExecutableQueueUpdate executableQueueUpdate) {
        this.eventCounter.incrementAndGet();
        log.debug((Object)"A new executable may be available on the server.");
        AtomicLong atomicLong = this.eventCounter;
        synchronized (atomicLong) {
            this.eventCounter.notifyAll();
        }
    }

    private static class BuildWarningsFileController
    implements AutoCloseable {
        private File aggregationFile;

        public BuildWarningsFileController(BuildWarningSummaryCollationService buildWarningSummaryCollationService, CommonContext context) {
            this.aggregationFile = buildWarningSummaryCollationService.aggregationFileForCommonContext(context);
            BambooFileUtils.deleteQuietly((File)this.aggregationFile);
        }

        @Override
        public void close() {
            BambooFileUtils.deleteQuietly((File)this.aggregationFile);
        }
    }
}

