/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.log4j.Logger;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;

public class DebugMessageConverter
implements MessageConverter {
    private static final Logger log = Logger.getLogger(DebugMessageConverter.class);
    private final MessageConverter delegate;

    private static void logSerializableObjects(Object object, PrintWriter printWriter, int level, String prefix, IdentityHashMap<Serializable, Void> seen) {
        if (object != null) {
            DebugMessageConverter.printIndent(level, printWriter);
            printWriter.print(prefix);
            Class<?> objectClass = object.getClass();
            printWriter.print(objectClass.getName());
            printWriter.print('@');
            printWriter.print(Integer.toHexString(System.identityHashCode(object)));
            if (object instanceof Serializable) {
                Serializable serializable = (Serializable)object;
                if (seen.containsKey(serializable)) {
                    printWriter.println(" (see above)");
                } else if (object instanceof String) {
                    printWriter.print(" = \"");
                    printWriter.print(object);
                    printWriter.println('\"');
                } else {
                    printWriter.println();
                    seen.put(serializable, null);
                    if (objectClass.isArray() && !objectClass.getComponentType().isPrimitive()) {
                        Object[] array = (Object[])serializable;
                        for (int index = 0; index < array.length; ++index) {
                            Object element = array[index];
                            DebugMessageConverter.logSerializableObjects(element, printWriter, level + 1, "[" + index + "] = ", seen);
                        }
                    } else {
                        Class<?> superclass = objectClass;
                        ++level;
                        do {
                            DebugMessageConverter.printIndent(level, printWriter);
                            printWriter.print(superclass.getName());
                            ClassHandler classHandler = DebugMessageConverter.getHandler(superclass);
                            classHandler.printWarning(printWriter);
                            printWriter.println();
                            for (DataItem dataItem : classHandler.getDataItems(superclass)) {
                                dataItem.print(serializable, printWriter, level, seen);
                            }
                        } while ((superclass = superclass.getSuperclass()) != null);
                    }
                }
            } else {
                printWriter.println(" ** NOT SERIALIZABLE **");
            }
        }
    }

    private static ClassHandler getHandler(Class objectClass) {
        if (objectClass.equals(HashMap.class)) {
            return RecognisedWriteObjectClassHandler.INSTANCE;
        }
        if (objectClass.equals(Date.class)) {
            return new RecognisedWriteObjectClassHandler(){

                @Override
                public Iterable<? extends DataItem> getDataItems(Class<?> objectClass) {
                    return Collections.emptySet();
                }
            };
        }
        try {
            objectClass.getDeclaredMethod("writeObject", ObjectOutputStream.class);
            return UnrecognisedWriteObjectClassHandler.INSTANCE;
        }
        catch (NoSuchMethodException exception) {
            return new ClassHandler(){
                final Predicate<Field> isNonPrimitiveNonTransientNonStatic = field -> {
                    if (field.getType().isPrimitive()) {
                        return false;
                    }
                    int modifiers = field.getModifiers();
                    return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers);
                };

                @Override
                public void printWarning(PrintWriter printWriter) {
                }

                @Override
                public Iterable<? extends DataItem> getDataItems(Class<?> objectClass) {
                    return Arrays.stream(objectClass.getDeclaredFields()).filter(this.isNonPrimitiveNonTransientNonStatic).map(x$0 -> new FieldDataItem((Field)x$0)).collect(Collectors.toList());
                }
            };
        }
    }

    private static void printIndent(int level, PrintWriter printWriter) {
        for (int indent = 0; indent < level; ++indent) {
            printWriter.print("    ");
        }
    }

    public DebugMessageConverter() {
        this((MessageConverter)new SimpleMessageConverter());
    }

    public DebugMessageConverter(MessageConverter delegate) {
        this.delegate = delegate;
    }

    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        if (object instanceof Serializable && log.isDebugEnabled()) {
            StringWriter stringWriter = new StringWriter();
            try (PrintWriter printWriter = new PrintWriter(stringWriter);){
                printWriter.println();
                DebugMessageConverter.logSerializableObjects(object, printWriter, 0, "", new IdentityHashMap<Serializable, Void>());
            }
            log.debug((Object)stringWriter);
        }
        return this.delegate.toMessage(object, session);
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        return this.delegate.fromMessage(message);
    }

    private static class RecognisedWriteObjectClassHandler
    extends UnrecognisedWriteObjectClassHandler {
        private static final RecognisedWriteObjectClassHandler INSTANCE = new RecognisedWriteObjectClassHandler();

        private RecognisedWriteObjectClassHandler() {
        }

        @Override
        public void printWarning(PrintWriter printWriter) {
            printWriter.print(" (Recognised writeObject implementation)");
        }
    }

    private static class UnrecognisedWriteObjectClassHandler
    implements ClassHandler {
        private static final UnrecognisedWriteObjectClassHandler INSTANCE = new UnrecognisedWriteObjectClassHandler();

        private UnrecognisedWriteObjectClassHandler() {
        }

        @Override
        public void printWarning(PrintWriter printWriter) {
            printWriter.print(" ** UNRECOGNISED writeObject IMPLEMENTATION **");
        }

        @Override
        public Iterable<? extends DataItem> getDataItems(Class<?> objectClass) {
            Predicate<Field> isNotPrimitive = field -> !field.getType().isPrimitive();
            return Arrays.stream(objectClass.getDeclaredFields()).filter(isNotPrimitive).map(x$0 -> new FieldDataItem((Field)x$0)).collect(Collectors.toList());
        }
    }

    private static class FieldDataItem
    extends DataItem {
        private final Field field;

        private FieldDataItem(Field field) {
            this.field = field;
        }

        @Override
        void print(Object object, PrintWriter printWriter, int level, IdentityHashMap<Serializable, Void> seen) {
            Object fieldValue;
            boolean accessible = this.field.isAccessible();
            if (!accessible) {
                this.field.setAccessible(true);
            }
            try {
                fieldValue = this.field.get(object);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            finally {
                if (!accessible) {
                    this.field.setAccessible(false);
                }
            }
            DebugMessageConverter.logSerializableObjects(fieldValue, printWriter, level + 1, this.field.getName() + " = ", seen);
        }
    }

    private static abstract class DataItem {
        private DataItem() {
        }

        abstract void print(Object var1, PrintWriter var2, int var3, IdentityHashMap<Serializable, Void> var4);
    }

    private static interface ClassHandler {
        public void printWarning(PrintWriter var1);

        public Iterable<? extends DataItem> getDataItems(Class<?> var1);
    }
}

