/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.AgentTypeHolder;
import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.build.pipeline.tasks.ExecuteBuildTask;
import com.atlassian.bamboo.build.pipeline.tasks.PrepareBuildTask;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.exception.StartupException;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildChangesImpl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.CommonContextHelper;
import com.atlassian.bamboo.v2.build.agent.AgentBuildingStatus;
import com.atlassian.bamboo.v2.build.agent.AgentCancellingStatus;
import com.atlassian.bamboo.v2.build.agent.AgentIdleStatus;
import com.atlassian.bamboo.v2.build.agent.AgentOfflineStatus;
import com.atlassian.bamboo.v2.build.agent.AgentStatus;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.BuildAgentController;
import com.atlassian.bamboo.v2.build.agent.BuildPhase;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.InterruptibleBuildPhase;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.docker.DockerContainerController;
import com.atlassian.bamboo.v2.build.task.InitializeBuild;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class DefaultBuildAgent
implements ExecutableBuildAgent {
    private static final Logger log = Logger.getLogger(DefaultBuildAgent.class);
    private static final List<Class<? extends BuildPhase>> BUILD_PHASE_CLASSES = Arrays.asList(PrepareBuildTask.class, ExecuteBuildTask.class);
    private static final int MAX_ERROR_COUNT = 10;
    @Inject
    private BuildAgentController buildAgentController;
    private final SystemAuthorityThreadFactory threadFactory;
    private MainAgentThread mainAgentThread;
    private final AtomicInteger errorCount = new AtomicInteger(0);
    @GuardedBy(value="this")
    private boolean stopping;
    @GuardedBy(value="this")
    private boolean cancelling;
    protected volatile CommonContext buildContext;
    @GuardedBy(value="this")
    private boolean enabled;
    @GuardedBy(value="this")
    private BuildPhase phase;
    private final long agentId;
    private final String agentName;
    private final String agentDescription;

    public DefaultBuildAgent(long agentId, String agentName, @Nullable String agentDescription) {
        this.agentId = agentId;
        this.agentName = agentName;
        this.agentDescription = StringUtils.defaultString((String)agentDescription);
        this.threadFactory = new SystemAuthorityThreadFactory("BAM::" + this.getName() + "::Agent");
    }

    public long getId() {
        return this.agentId;
    }

    public String getName() {
        return this.agentName;
    }

    @NotNull
    public String getDescription() {
        return this.agentDescription;
    }

    public synchronized void start() {
        if (!this.isActive()) {
            this.prepareAgentForBuild();
            this.mainAgentThread = (MainAgentThread)this.threadFactory.newThread(MainAgentThread.class, () -> {
                try {
                    this.buildAgentController.prepareForBuilding((ExecutableBuildAgent)this);
                    this.buildAgentController.sendPreviousBuildResultIfRequired((ExecutableBuildAgent)this);
                    this.onAgentReadyToBuild();
                    while (!this.isStopping()) {
                        if (this.buildAgentController.hasPreviousBuildResultToSend((ExecutableBuildAgent)this)) {
                            try {
                                Thread.sleep(TimeUnit.SECONDS.toMillis(SystemProperty.BUILD_RESULT_RETRY_DELAY_SECONDS.getTypedValue()));
                            }
                            catch (InterruptedException e) {
                                if (!this.mainAgentThread.isStopFlagRaised()) continue;
                                break;
                            }
                            if (!this.buildAgentController.sendPreviousBuildResultIfRequired((ExecutableBuildAgent)this)) continue;
                            this.onBetweenBuilds();
                            continue;
                        }
                        this.buildAgentController.waitAndPerformBuild((ExecutableBuildAgent)this);
                        if (this.buildAgentController.hasPreviousBuildResultToSend((ExecutableBuildAgent)this)) continue;
                        this.onBetweenBuilds();
                    }
                    DefaultBuildAgent e = this;
                    synchronized (e) {
                        this.stopping = false;
                    }
                }
                catch (Throwable e) {
                    log.fatal((Object)("Uncaught exception thrown on agent '" + this.getName() + "' (" + this.getId() + "). Agent stopping..."), e);
                }
                finally {
                    this.onMainThreadEnd();
                }
            });
            this.mainAgentThread.start();
            log.info((Object)("Build agent '" + this.getName() + "' started. Waiting for builds..."));
        } else {
            log.warn((Object)("Attempting to start agent '" + this.getName() + "' but already active"));
        }
    }

    protected void onAgentReadyToBuild() {
    }

    protected void onBetweenBuilds() {
    }

    protected void onMainThreadEnd() {
        log.info((Object)("Build agent '" + this.getName() + "' stopped."));
        this.buildAgentController.finishBuilding((ExecutableBuildAgent)this);
    }

    private void prepareAgentForBuild() {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        try {
            log.info((Object)("Ensuring the temp path '" + tempDirPath + "' exists."));
            FileUtils.forceMkdir((File)new File(tempDirPath));
        }
        catch (IOException e) {
            throw new StartupException("Unable to startup agent. Cannot create temp directory '" + tempDirPath + "'. Bamboo requires a tmp directory to operate correctly, so please ensure you have the correct permission", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(@NotNull ReadOnlyCapabilitySet agentCapabilities, @NotNull DockerContainerController dockerContainerController) throws Exception {
        try {
            if (this.executeBuildPhase(agentCapabilities, InitializeBuild.class)) {
                return;
            }
            dockerContainerController.startContainerIfRequired();
            for (Class<? extends BuildPhase> phaseClass : BUILD_PHASE_CLASSES) {
                if (!this.executeBuildPhase(agentCapabilities, phaseClass)) continue;
                break;
            }
        }
        finally {
            this.phase = null;
            if (this.cancelling) {
                this.cancelling = false;
                Thread.interrupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeBuildPhase(@NotNull ReadOnlyCapabilitySet agentCapabilities, Class<? extends BuildPhase> phaseClass) throws Exception {
        DefaultBuildAgent defaultBuildAgent = this;
        synchronized (defaultBuildAgent) {
            if (this.cancelling) {
                log.info((Object)"Detected that build was cancelled... Aborting build process.");
                return true;
            }
            if (this.buildContext.getErrorCollection().hasAnyErrors()) {
                log.info((Object)("Detected '" + this.buildContext.getErrorCollection().getTotalErrors() + "' errors in build. Aborting build process."));
                return true;
            }
            log.info((Object)("Running build phase: " + phaseClass.getName()));
            this.phase = (BuildPhase)ContainerManager.getInstance().getContainerContext().createCompleteComponent(phaseClass);
        }
        this.phase.call(this.buildContext, agentCapabilities);
        return false;
    }

    public synchronized void onBuildProcessingFinished() {
        this.phase = null;
        this.setContext(null);
        this.cancelling = false;
        this.mainAgentThread.clearStopFlag();
    }

    private void setContext(@Nullable CommonContext newContext) {
        ResultKey newResultKey = newContext != null ? newContext.getResultKey() : null;
        ResultKey oldResultKey = this.buildContext != null ? this.buildContext.getResultKey() : null;
        log.info((Object)("Changing context: " + oldResultKey + " -> " + newResultKey + " on " + this.getName() + "/" + Long.toHexString(System.identityHashCode(this))));
        this.buildContext = newContext;
    }

    public void onContextReceived(@NotNull CommonContext commonContext) {
        BuildContext receivedContext;
        if (AgentTypeHolder.get().equals((Object)AgentType.LOCAL) && (receivedContext = (BuildContext)Narrow.downTo((Object)commonContext, BuildContext.class)) != null && receivedContext.getBuildChanges() != null) {
            receivedContext.setBuildChanges((BuildChanges)new BuildChangesImpl(receivedContext.getBuildChanges()));
        }
    }

    public synchronized boolean cancelBuild(@NotNull String buildResultKey) {
        log.info((Object)("Cancel build request for '" + buildResultKey + "' received on agent '" + this.getName() + "'."));
        if (this.buildContext == null) {
            log.warn((Object)("Request to cancel build '" + buildResultKey + "' ignored. Agent '" + this.getName() + "' not building anything."));
            return false;
        }
        if (!buildResultKey.equals(this.buildContext.getResultKey().getKey())) {
            log.warn((Object)("Request to cancel build '" + buildResultKey + "' ignored. Agent '" + this.getName() + "' is building " + this.buildContext.getResultKey()));
            return false;
        }
        this.cancelling = true;
        if (this.phase instanceof InterruptibleBuildPhase) {
            log.info((Object)("Interrupting task " + this.phase + "."));
            this.mainAgentThread.interruptBuilding();
        } else {
            log.info((Object)("Running task " + this.phase + " which can not be interrupted."));
        }
        return true;
    }

    public synchronized <V> V executeWithCurrentContext(Callable<V> callable) throws Exception {
        return callable.call();
    }

    public void waitForStop(int secondsToWait) throws TimeoutException {
        long timeLeft;
        long waitSlice = timeLeft / 5L;
        for (timeLeft = TimeUnit.SECONDS.toMillis(secondsToWait); timeLeft > 0L; timeLeft -= waitSlice) {
            if (!this.isActive()) {
                return;
            }
            try {
                this.mainAgentThread.join(waitSlice);
                continue;
            }
            catch (InterruptedException e) {
                throw new TimeoutException("Agent stopping interrupted prematurely");
            }
        }
        throw new TimeoutException("Unable to stop agent in " + secondsToWait + " seconds");
    }

    public int incrementError() {
        int errorCnt = this.errorCount.incrementAndGet();
        if (this.errorCount.intValue() >= 10) {
            log.fatal((Object)"Maximum number of errors has been reached (10). Agent will now stop.");
            this.stop();
        } else {
            log.warn((Object)(errorCnt + " attempts at building without a successful run. The agent will stop after reaching 10 exceptions."));
        }
        return errorCnt;
    }

    public void resetErrors() {
        this.errorCount.set(0);
    }

    public synchronized boolean isCancelling() {
        return this.cancelling;
    }

    public synchronized void stop() {
        if (this.isActive()) {
            this.stopping = true;
            if (this.buildContext != null) {
                this.cancelBuild(this.buildContext.getResultKey().getKey());
            } else {
                this.shutdown();
            }
        } else {
            log.warn((Object)("Stop called on '" + this.getName() + "' but already stopped"));
        }
    }

    protected void shutdown() {
        this.mainAgentThread.interrupt();
    }

    public synchronized void stopNicely() {
        if (this.isActive()) {
            this.stopping = true;
            if (this.buildContext == null) {
                this.mainAgentThread.interrupt();
            }
        } else {
            log.warn((Object)("Stop called on '" + this.getName() + "' but already stopped"));
        }
    }

    public void stopNicely(int statusCode) {
        log.warn((Object)"Ignoring termination status code, as the current agent does not support it.");
        this.stopNicely();
    }

    @Nullable
    public CommonContext getBuilding() {
        return this.buildContext;
    }

    public void setContextToBuild(@NotNull CommonContext newContext) {
        Preconditions.checkNotNull((Object)newContext, (Object)"Attempted to set a null context");
        Preconditions.checkState((this.buildContext == null ? 1 : 0) != 0, (Object)("Already building '" + (this.buildContext != null ? this.buildContext.getResultKey() : null) + "' rejected build '" + newContext.getResultKey() + "'"));
        this.setContext(newContext);
        CommonContextHelper.rewire((CommonContext)this.buildContext);
    }

    public synchronized void enable() {
        this.enabled = true;
    }

    public synchronized void disable() {
        this.enabled = false;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized AgentStatus getAgentStatus() {
        if (!this.isActive()) {
            return AgentOfflineStatus.getInstance();
        }
        if (this.buildContext != null) {
            long deploymentResultId = -1L;
            String displayName = this.buildContext.getResultKey().getKey();
            DeploymentContext deploymentContext = (DeploymentContext)Narrow.to((Object)this.buildContext, DeploymentContext.class);
            if (deploymentContext != null) {
                deploymentResultId = deploymentContext.getDeploymentResultId();
                displayName = this.buildContext.getDisplayName();
            }
            if (this.cancelling) {
                return new AgentCancellingStatus(this.buildContext.getResultKey(), displayName, deploymentResultId);
            }
            return new AgentBuildingStatus(this.buildContext.getResultKey(), displayName, deploymentResultId);
        }
        return AgentIdleStatus.getInstance();
    }

    public synchronized boolean isStopping() {
        return this.stopping;
    }

    public synchronized boolean isActive() {
        return this.mainAgentThread != null && this.mainAgentThread.isAlive();
    }

    public int hashCode() {
        return new HashCodeBuilder(643, 7).append((Object)this.getName()).append(this.getId()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildAgent)) {
            return false;
        }
        BuildAgent rhs = (BuildAgent)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).append(this.getId(), rhs.getId()).isEquals();
    }

    public int compareTo(BuildAgent o) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)o.getName()).append(this.getId(), o.getId()).toComparison();
    }

    public static class MainAgentThread
    extends Thread {
        private final AtomicBoolean stopFlagRaised = new AtomicBoolean(false);

        public MainAgentThread(Runnable target) {
            super(target);
        }

        @Override
        public void interrupt() {
            log.debug((Object)"Interrupt called");
            this.stopFlagRaised.set(true);
            super.interrupt();
        }

        public void interruptBuilding() {
            log.debug((Object)"Interrupt building called");
            super.interrupt();
        }

        public boolean isStopFlagRaised() {
            return this.stopFlagRaised.get();
        }

        public void clearStopFlag() {
            this.stopFlagRaised.set(false);
        }
    }
}

