/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.amq.AgentJmsUtils;
import com.atlassian.bamboo.event.ServerFingerprintBroadcastEvent;
import com.atlassian.bamboo.event.ServerFingerprintBroadcastEventV2;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.setup.ServerFingerprint;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.bamboo.v2.build.agent.BambooAgentMessageDeliverer;
import com.atlassian.event.api.EventPublisher;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.springframework.jms.support.converter.MessageConverter;

public class HeartbeatMessageListener
extends BambooAgentMessageDeliverer
implements MessageListener {
    private static final Logger log = Logger.getLogger(HeartbeatMessageListener.class);
    private final MessageConverter messageConverter;
    private final ServerFingerprint serverFingerprint;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;

    public HeartbeatMessageListener(MessageConverter messageConverter, ServerFingerprint serverFingerprint, EventPublisher eventPublisher, FeatureManager featureManager) {
        this.messageConverter = messageConverter;
        this.serverFingerprint = serverFingerprint;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
    }

    public void onMessage(Message message) {
        if (!(message instanceof TextMessage)) {
            log.error((Object)("Unrecognised Message class: " + message.getClass().getName()));
            return;
        }
        try {
            ImpersonationHelper.runWithSystemAuthority(this.processMessage(message));
        }
        catch (JMSException e) {
            log.warn((Object)("Unable to deliver message " + message), (Throwable)e);
        }
    }

    private BambooRunnables.Throwing1<JMSException> processMessage(Message message) {
        return () -> {
            String serverFingerprintFromMessage = message.getStringProperty("fingerprint");
            Long instanceFingerprintFromMessage = AgentJmsUtils.getInstanceFingerprint(message);
            if (instanceFingerprintFromMessage == null) {
                log.info((Object)("Agent sent fingerprint in an old format: [" + serverFingerprintFromMessage + "], and attempt will be made to bring it down. Message: " + message));
                this.eventPublisher.publish((Object)new ServerFingerprintBroadcastEvent("deliberatelyInvalidFingerprint"));
                return;
            }
            ServerFingerprint fingerprintFromMessage = new ServerFingerprint(serverFingerprintFromMessage, instanceFingerprintFromMessage.longValue());
            if (this.serverFingerprint.getServerFingerprint().equals(fingerprintFromMessage.getServerFingerprint())) {
                Object o = this.messageConverter.fromMessage(message);
                this.deliverObject(o);
            }
            if (!this.serverFingerprint.equals((Object)fingerprintFromMessage)) {
                boolean isSameServer = this.serverFingerprint.getServerFingerprint().equals(fingerprintFromMessage.getServerFingerprint());
                Level priority = isSameServer && this.featureManager.isSeamlessRestartEnabled() ? Level.DEBUG : Level.INFO;
                log.log((Priority)priority, (Object)("Agent sent an incorrect fingerprint in a JMS message " + fingerprintFromMessage + ", an attempt will be made to bring it down."));
                this.eventPublisher.publish((Object)new ServerFingerprintBroadcastEventV2(this.serverFingerprint, fingerprintFromMessage));
            }
        };
    }
}

