/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.CustomBuildProcessorServer;
import com.atlassian.bamboo.build.ServerBuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.FileWritingBuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.event.BuildCompletedEvent;
import com.atlassian.bamboo.execution.ExecutionPhaseService;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.PlanStatePersisterService;
import com.atlassian.bamboo.plugin.descriptor.CustomBuildProcessorServerModuleDescriptor;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.v2.build.BuildCancelledDetails;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.events.PostBuildCompletedEvent;
import com.atlassian.bamboo.variable.CustomVariableContextRunner;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LocalBuildResultProcessor {
    private static final Logger log = Logger.getLogger(LocalBuildResultProcessor.class);
    private final BuildExecutionManager buildExecutionManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final EventPublisher eventPublisher;
    private final ServerBuildLoggerManager buildLoggerManager;
    private final PluginAccessor pluginAccessor;
    private final PlanStatePersisterService planStatePersisterService;
    private final CustomVariableContextRunner customVariableContextRunner;
    private final ExecutionPhaseService executionPhaseService;

    public LocalBuildResultProcessor(BuildExecutionManager buildExecutionManager, ResultsSummaryManager resultsSummaryManager, EventPublisher eventManager, ServerBuildLoggerManager buildLoggerManager, PluginAccessor pluginAccessor, PlanStatePersisterService planStatePersisterService, CustomVariableContextRunner customVariableContextRunner, ExecutionPhaseService executionPhaseService) {
        this.buildExecutionManager = buildExecutionManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.eventPublisher = eventManager;
        this.buildLoggerManager = buildLoggerManager;
        this.pluginAccessor = pluginAccessor;
        this.planStatePersisterService = planStatePersisterService;
        this.customVariableContextRunner = customVariableContextRunner;
        this.executionPhaseService = executionPhaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBuildResult(@NotNull BuildContext buildContext) {
        PlanResultKey planResultKey = buildContext.getPlanResultKey();
        CurrentlyBuilding building = this.buildExecutionManager.getCurrentlyBuildingByBuildResult((BuildIdentifier)buildContext);
        if (building == null) {
            this.terminateBuild(planResultKey);
            log.error((Object)("Build processor detected a build completion message for: " + buildContext.getPlanResultKey() + ", but is not marked as currently building on the server. Message ignored ..."));
            return;
        }
        if (!Objects.equals(building.getBuildIdentifier().getUuid(), buildContext.getUuid())) {
            log.error((Object)String.format("Late arrival detected: found CRB for %s but UUID doesn't match. Message ignored ...", buildContext.getPlanResultKey()));
            return;
        }
        building.tryToFinish();
        log.info((Object)("Processing build result " + buildContext.getPlanResultKey() + "..."));
        boolean savingCompleted = false;
        FileWritingBuildLogger buildLogger = this.buildLoggerManager.getPersistentLogger((ResultKey)planResultKey);
        BuildLogger planLogger = this.buildLoggerManager.getLogger((Key)planResultKey.getPlanKey());
        try {
            boolean isCancelled;
            this.executionPhaseService.executionFinished((CommonContext)buildContext);
            CurrentBuildResult buildResult = buildContext.getBuildResult();
            BuildCancelledDetails cancellationDetails = building.getBuildCancelledDetails();
            LifeCycleState currentLifeCycleState = buildResult.getLifeCycleState();
            if (LifeCycleState.isInProgress((LifeCycleState)currentLifeCycleState)) {
                this.performCustomBuildProcessServer((BuildLogger)buildLogger, buildContext);
            }
            boolean bl = isCancelled = cancellationDetails != null;
            if (isCancelled) {
                buildResult.setLifeCycleState(LifeCycleState.NOT_BUILT);
                buildResult.setBuildState(BuildState.UNKNOWN);
                planLogger.addBuildLogEntry("Build " + planResultKey.getKey() + " was " + cancellationDetails.getActionSource().stoppedHow() + ".");
                buildResult.addBuildErrors(Collections.singletonList("Build was " + cancellationDetails.getActionSource().stoppedHow() + "."));
            } else {
                buildResult.setLifeCycleState(LifeCycleState.FINISHED);
                switch (buildResult.getBuildState()) {
                    case SUCCESS: {
                        planLogger.addBuildLogEntry("Build " + planResultKey.getKey() + " has completed successfully.");
                        break;
                    }
                    case UNKNOWN: {
                        buildResult.setLifeCycleState(LifeCycleState.NOT_BUILT);
                        planLogger.addBuildLogEntry("Build " + planResultKey.getKey() + " was not built.");
                        break;
                    }
                    case FAILED: {
                        planLogger.addBuildLogEntry("Build " + planResultKey.getKey() + " has failed.");
                        break;
                    }
                }
            }
            try {
                buildContext = this.planStatePersisterService.saveFinishedBuildResult(buildContext);
            }
            catch (Exception exception) {
                log.error((Object)"Error while saving build results", (Throwable)exception);
                throw new RuntimeException(exception);
            }
            savingCompleted = true;
        }
        finally {
            buildLogger.stopStreamingBuildLogs();
            if (savingCompleted) {
                this.resultsSummaryManager.invalidateLogSize(PlanKeys.getChainResultKey((PlanResultKey)planResultKey));
                ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
                this.eventPublisher.publish((Object)new BuildCompletedEvent((Object)this, buildContext.getPlanResultKey(), resultsSummary.getBuildState(), resultsSummary.getLifeCycleState()));
                this.buildExecutionManager.finishBuildWithCleanState(planResultKey, buildContext);
                this.eventPublisher.publish((Object)new PostBuildCompletedEvent((Object)this, buildContext));
            } else {
                try {
                    this.resultsSummaryManager.invalidateLogSize(planResultKey);
                    this.terminateBuild(planResultKey);
                }
                catch (Exception e) {
                    log.error((Object)("Build " + planResultKey + " didn't terminate properly, delaying termination of the build."), (Throwable)e);
                    building.abortFinishing();
                }
            }
        }
    }

    private void performCustomBuildProcessServer(BuildLogger buildLogger, BuildContext buildContext) {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CustomBuildProcessorServerModuleDescriptor.class);
        this.customVariableContextRunner.execute((CommonContext)buildContext, () -> {
            for (CustomBuildProcessorServerModuleDescriptor moduleDescriptor : moduleDescriptors) {
                log.debug((Object)buildLogger.addBuildLogEntry("Running on server: post build plugin '" + moduleDescriptor.getName() + "'"));
                CustomBuildProcessorServer buildProcessor = (CustomBuildProcessorServer)moduleDescriptor.getModule();
                if (buildProcessor == null) continue;
                try {
                    buildProcessor.init(buildContext);
                    buildProcessor.call();
                }
                catch (InterruptedException e) {
                    log.warn((Object)("Running of app " + buildProcessor + " was interuptted."));
                }
                catch (Throwable e) {
                    log.warn((Object)("Failed to execute app module " + moduleDescriptor.getModuleClass().getName() + " : " + buildContext.getPlanResultKey()), e);
                    buildLogger.addErrorLogEntry("Failed to execute app '" + moduleDescriptor.getName() + "' with error: " + e.getMessage());
                }
            }
        });
        log.debug((Object)buildLogger.addBuildLogEntry("All post build plugins have finished"));
    }

    public void terminateBuild(PlanResultKey resultKey) {
        this.buildExecutionManager.finishBuild(resultKey, true);
    }
}

