/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.deployments.DeploymentResultKey;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.deployments.execution.service.DeploymentExecutionService;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.LocalBuildResultProcessor;
import com.atlassian.bamboo.v2.build.agent.LocalResultProcessor;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class LocalResultProcessorImpl
implements LocalResultProcessor {
    private static final Logger log = Logger.getLogger(LocalResultProcessorImpl.class);
    private final LocalBuildResultProcessor localBuildResultProcessor;
    @Lazy
    @Autowired
    private DeploymentExecutionService deploymentExecutionService;

    public LocalResultProcessorImpl(@NotNull LocalBuildResultProcessor localBuildResultProcessor) {
        this.localBuildResultProcessor = localBuildResultProcessor;
    }

    public void processResult(@NotNull CommonContext context) {
        if (context instanceof BuildContext) {
            this.localBuildResultProcessor.processBuildResult((BuildContext)context);
        } else if (context instanceof DeploymentContext) {
            this.deploymentExecutionService.processDeploymentResult((DeploymentContext)context);
        } else {
            throw new IllegalStateException("Trying to process a result that is not a build or deployment: " + context.getClass());
        }
    }

    public void terminateResult(@NotNull ResultKey resultKey) {
        if (resultKey instanceof PlanResultKey) {
            this.localBuildResultProcessor.terminateBuild((PlanResultKey)resultKey);
        } else if (resultKey instanceof DeploymentResultKey) {
            this.deploymentExecutionService.terminateDeployment((DeploymentResultKey)resultKey);
        } else {
            throw new IllegalStateException("Trying to terminate a result that is neither build nor deployment: " + resultKey.getKey());
        }
    }
}

