/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildOutputLogEntry;
import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.SimpleLogEntry;
import com.atlassian.bamboo.build.logger.LoggerId;
import com.atlassian.bamboo.build.logger.LoggerIds;
import com.atlassian.bamboo.deployments.DeploymentKeyImpl;
import com.atlassian.bamboo.deployments.DeploymentResultKeyImpl;
import com.atlassian.bamboo.plan.DeploymentResultKeyAsPlanResultKey;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.messages.AbstractAddLogEntry;
import com.atlassian.bamboo.v2.build.agent.messages.AddBuildLogEntry;
import com.atlassian.bamboo.v2.build.agent.messages.AddErrorLogEntry;
import com.atlassian.bamboo.v2.build.agent.messages.BambooAgentMessage;
import com.atlassian.bamboo.v2.build.agent.messages.LogMessageBatch;
import com.atlassian.bamboo.v2.build.agent.messages.LogMessageStream;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Queue;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class LogMessageBatchConverter
implements MessageConverter {
    private static final Logger log = Logger.getLogger(LogMessageBatchConverter.class);
    private static final Charset TRANSFER_CHARSET = StandardCharsets.UTF_8;
    private static final int LOG_ENTRY_BUILD_OUTPUT_LOG_ENTRY = 0;
    private static final int LOG_ENTRY_ERROR_LOG_ENTRY = 1;
    private static final int LOG_ENTRY_COMMAND_LOG_ENTRY = 2;
    private static final int LOG_ENTRY_SIMPLE_LOG_ENTRY = 3;
    private static final byte KEY_NONE = 0;
    private static final byte KEY_PLAN_KEY = 1;
    private static final byte KEY_PLAN_RESULT_KEY = 2;
    private static final byte KEY_DEPLOYMENT_KEY = 3;
    private static final byte KEY_DEPLOYMENT_RESULT_KEY = 4;
    private static final byte NON_PERSISTENCE_BIT = 64;
    private static final ImmutableMap<Class<? extends LogEntry>, Byte> LOG_ENTRY_CLASS_TO_ID = ImmutableMap.of(BuildOutputLogEntry.class, (Object)0, ErrorLogEntry.class, (Object)1, CommandLogEntry.class, (Object)2, SimpleLogEntry.class, (Object)3);
    private static final ImmutableMap<Class<? extends Serializable>, Byte> KEY_CLASS_TO_ID = ImmutableMap.of(PlanKey.class, (Object)1, PlanResultKey.class, (Object)2, DeploymentKeyImpl.class, (Object)3, DeploymentResultKeyImpl.class, (Object)4, DeploymentResultKeyAsPlanResultKey.class, (Object)4);
    private static final ImmutableMap<Class<? extends AbstractAddLogEntry>, Byte> LOG_MESSAGE_CLASS_TO_DEST_ID = ImmutableMap.of(AddBuildLogEntry.class, (Object)1, AddErrorLogEntry.class, (Object)0);

    private static Message createMessage(Session session, LogMessageBatch logMessageBatch) throws JMSException {
        AbstractAddLogEntry message;
        BytesMessage jmsMessage = session.createBytesMessage();
        Queue<AbstractAddLogEntry> messagesToSend = logMessageBatch.drainMessages();
        int size = messagesToSend.size();
        log.debug((Object)("Serialising " + size + " log messages"));
        LogMessageBatchConverter.writeMessageCount(jmsMessage, size);
        LoggerId<? extends Key> loggerId = logMessageBatch.getLoggerId();
        LogMessageBatchConverter.writeLoggerId(jmsMessage, loggerId, logMessageBatch.getNeedToPersistOnTarget());
        while ((message = messagesToSend.poll()) != null) {
            LogMessageBatchConverter.writeLogEntry(jmsMessage, message);
        }
        return jmsMessage;
    }

    public static AbstractAddLogEntry readLogEntry(LoggerId<? extends Key> loggerId, BytesMessage jmsMessage) throws JMSException {
        BuildOutputLogEntry logEntry;
        Date timestamp = new Date(jmsMessage.readLong());
        String log = LogMessageBatchConverter.readUtf(jmsMessage);
        byte logClassId = jmsMessage.readByte();
        byte persistentMessage = jmsMessage.readByte();
        byte afterLogSpoolClosed = jmsMessage.readByte();
        switch (logClassId) {
            case 0: {
                logEntry = new BuildOutputLogEntry(log, timestamp);
                break;
            }
            case 1: {
                logEntry = new ErrorLogEntry(log, timestamp);
                break;
            }
            case 2: {
                logEntry = new CommandLogEntry(log, timestamp);
                break;
            }
            case 3: {
                logEntry = new SimpleLogEntry(log, timestamp);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown log class: " + logClassId);
            }
        }
        byte destination = jmsMessage.readByte();
        switch (destination) {
            case 1: {
                return new AddBuildLogEntry(loggerId, persistentMessage != 0, afterLogSpoolClosed != 0, (LogEntry)logEntry);
            }
            case 0: {
                return new AddErrorLogEntry(loggerId, persistentMessage != 0, afterLogSpoolClosed != 0, (LogEntry)logEntry);
            }
        }
        throw new IllegalArgumentException("Unknown destination: " + destination);
    }

    private static void writeLogEntry(BytesMessage jmsMessage, AbstractAddLogEntry message) throws JMSException {
        LogEntry logEntry = message.getLogEntry();
        jmsMessage.writeLong(logEntry.getDate().getTime());
        LogMessageBatchConverter.writeUtf(jmsMessage, logEntry.getUnstyledLog());
        jmsMessage.writeByte(LogMessageBatchConverter.getLogClassId(message).byteValue());
        jmsMessage.writeByte(LogMessageBatchConverter.asByte(message.isNeedToPersistOnTarget()));
        jmsMessage.writeByte(LogMessageBatchConverter.asByte(message.isAddedAfterLogSpoolClosed()));
        jmsMessage.writeByte(LogMessageBatchConverter.getDestinationId(message).byteValue());
    }

    private static byte asByte(boolean input) {
        return (byte)Boolean.compare(input, false);
    }

    public static Byte getDestinationId(@NotNull AbstractAddLogEntry message) {
        return (Byte)LOG_MESSAGE_CLASS_TO_DEST_ID.get(message.getClass());
    }

    @Nullable
    private static Byte getLogClassId(@NotNull BambooAgentMessage bambooAgentMessage) {
        AbstractAddLogEntry addLogEntry = (AbstractAddLogEntry)Narrow.downTo((Object)bambooAgentMessage, AbstractAddLogEntry.class);
        if (addLogEntry == null) {
            return null;
        }
        return (Byte)LOG_ENTRY_CLASS_TO_ID.get(addLogEntry.getLogEntry().getClass());
    }

    public Message toMessage(Object o, Session session) throws JMSException, MessageConversionException {
        return LogMessageBatchConverter.createMessage(session, (LogMessageBatch)o);
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        return new LogMessageStream((BytesMessage)message);
    }

    public static int readMessageCount(BytesMessage jmsMessage) throws JMSException {
        return jmsMessage.readInt();
    }

    private static void writeMessageCount(BytesMessage jmsMessage, int size) throws JMSException {
        jmsMessage.writeInt(size);
    }

    @Nullable
    public static LoggerId<? extends Key> readLoggerId(BytesMessage jmsMessage) throws JMSException {
        LoggerId loggerId;
        byte loggerClassIdWithNonPersistentBit = jmsMessage.readByte();
        boolean nonPersistent = (loggerClassIdWithNonPersistentBit & 0x40) != 0;
        byte loggerClassId = (byte)(loggerClassIdWithNonPersistentBit & 0xFFFFFFBF);
        String key = jmsMessage.readUTF();
        switch (loggerClassId) {
            case 2: {
                loggerId = LoggerIds.get((ResultKey)PlanKeys.getPlanResultKey((String)key));
                break;
            }
            case 4: {
                loggerId = LoggerIds.get((ResultKey)DeploymentResultKeyImpl.from((String)key));
                break;
            }
            case 1: {
                loggerId = LoggerIds.get((Key)PlanKeys.getPlanKey((String)key));
                break;
            }
            case 3: {
                loggerId = LoggerIds.get((Key)new DeploymentKeyImpl(key));
                break;
            }
            case 0: {
                loggerId = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key type: " + loggerClassId);
            }
        }
        if (nonPersistent) {
            loggerId.disablePersisting();
        }
        return loggerId;
    }

    private static void writeLoggerId(BytesMessage jmsMessage, LoggerId<? extends Key> loggerId, Boolean needToPersistOnTarget) throws JMSException {
        if (loggerId == null) {
            jmsMessage.writeByte((byte)0);
            jmsMessage.writeUTF("");
            return;
        }
        Key key = loggerId.getKey();
        Byte classId = (Byte)KEY_CLASS_TO_ID.get(key.getClass());
        if (classId == null) {
            throw new IllegalArgumentException("Unknown key type: " + key.getClass());
        }
        byte classIdWithNonPersistenceBit = Boolean.TRUE.equals(needToPersistOnTarget) ? classId : (byte)(classId | 0x40);
        jmsMessage.writeByte(classIdWithNonPersistenceBit);
        String loggerIdString = key.toString();
        jmsMessage.writeUTF(loggerIdString);
    }

    @NotNull
    private static String readUtf(BytesMessage jmsMessage) throws JMSException {
        int bytesCount = jmsMessage.readInt();
        byte[] bytes = new byte[bytesCount];
        jmsMessage.readBytes(bytes);
        return new String(bytes, TRANSFER_CHARSET);
    }

    private static void writeUtf(BytesMessage jmsMessage, @Nullable String string) throws JMSException {
        byte[] bytes = ((String)StringUtils.defaultIfEmpty((CharSequence)string, (CharSequence)"")).getBytes(TRANSFER_CHARSET);
        jmsMessage.writeInt(bytes.length);
        jmsMessage.writeBytes(bytes);
    }

    public static class DestinationLog {
        public static final byte ERROR = 0;
        public static final byte OUTPUT = 1;

        private DestinationLog() {
        }
    }
}

