/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.v2.build.agent.MessageListenerContainerController;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.jms.listener.AbstractJmsListeningContainer;

public class MessageListenerContainerControllerImpl
implements MessageListenerContainerController {
    private static final Logger log = Logger.getLogger(MessageListenerContainerControllerImpl.class);
    private final Set<AbstractJmsListeningContainer> containers = new HashSet<AbstractJmsListeningContainer>();

    public void register(AbstractJmsListeningContainer jmsListeningContainer) {
        this.containers.add(jmsListeningContainer);
    }

    public synchronized Future<Boolean> stopAll() {
        HashSet<AbstractJmsListeningContainer> containersToStop = new HashSet<AbstractJmsListeningContainer>(this.containers);
        CountDownLatch cdl = new CountDownLatch(containersToStop.size());
        Runnable onStop = MessageListenerContainerControllerImpl.completionCounter(cdl);
        log.debug((Object)("Stopping " + containersToStop.size() + " message listener containers..."));
        for (AbstractJmsListeningContainer container : containersToStop) {
            container.stop(onStop);
        }
        return MessageListenerContainerControllerImpl.newFuture(cdl);
    }

    private static Runnable completionCounter(CountDownLatch cdl) {
        return cdl::countDown;
    }

    private static Future<Boolean> newFuture(final CountDownLatch cdl) {
        return new Future<Boolean>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return cdl.getCount() == 0L;
            }

            @Override
            public Boolean get() throws InterruptedException {
                this.logIfNeeded();
                cdl.await();
                return true;
            }

            @Override
            public Boolean get(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
                this.logIfNeeded();
                cdl.await(timeout, unit);
                return true;
            }

            private void logIfNeeded() {
                if (!this.isDone()) {
                    log.info((Object)"Waiting for message listener containers to stop...");
                }
            }
        };
    }

    public synchronized void startAll() {
        log.info((Object)"Starting listener containers");
        HashSet<AbstractJmsListeningContainer> containersToStart = new HashSet<AbstractJmsListeningContainer>(this.containers);
        for (AbstractJmsListeningContainer container : containersToStart) {
            log.trace((Object)("Starting container " + container));
            container.start();
        }
        log.info((Object)"All containers started.");
    }
}

