/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.amq.AgentJmsUtils;
import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.concurrent.BambooExecutors;
import com.atlassian.bamboo.concurrent.BlockingSet;
import com.atlassian.bamboo.utils.SystemProperty;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.jms.Message;
import javax.jms.MessageListener;

public class ParallelizingMessageListener
implements MessageListener {
    private static final int DEFAULT_MAX_CONCURRENT_MESSAGES = 10;
    private static final int DEFAULT_MAX_CONCURRENT_EXPENSIVE_MESSAGES = 1;
    private static final int DEFAULT_MAX_QUEUED_EXPENSIVE_MESSAGES = 2;
    private final BlockingSet<Object> oneMessagePerAgentLimiter = new BlockingSet();
    private final MessageListener messageListener;
    private final String listenerName;
    private int maxConcurrentMessages = 10;
    private int maxConcurrentExpensiveMessages = SystemProperty.MAX_CONCURRENT_EXPENSIVE_MESSAGES.getValue(1);
    private int maxQueuedExpensiveMessages = 2;
    private Executor plainMessageProcessors;
    private Executor expensiveMessageProcessors;

    public ParallelizingMessageListener(MessageListener messageListener, String listenerName) {
        this.messageListener = messageListener;
        this.listenerName = listenerName;
    }

    @PostConstruct
    public void createExecutors() {
        SystemAuthorityThreadFactory threadFactory = new SystemAuthorityThreadFactory(this.listenerName);
        SystemAuthorityThreadFactory expensiveThreadFactory = new SystemAuthorityThreadFactory(this.listenerName + "-expensive");
        this.plainMessageProcessors = BambooExecutors.newBlockingThreadPoolExecutor((int)this.maxConcurrentMessages, (long)60L, (TimeUnit)TimeUnit.SECONDS, new ArrayBlockingQueue(1), (ThreadFactory)threadFactory);
        this.expensiveMessageProcessors = BambooExecutors.newBlockingThreadPoolExecutor((int)this.maxConcurrentExpensiveMessages, (long)15L, (TimeUnit)TimeUnit.SECONDS, new ArrayBlockingQueue(this.maxQueuedExpensiveMessages), (ThreadFactory)expensiveThreadFactory);
    }

    public void onMessage(Message message) {
        this.delegate(message, AgentJmsUtils.getUuidHash(message));
    }

    private void delegate(Message message, Integer token) {
        this.oneMessagePerAgentLimiter.add((Object)token);
        try {
            Runnable command = this.onMessage(message, token);
            if (AgentJmsUtils.isExpensive(message)) {
                this.expensiveMessageProcessors.execute(command);
            } else {
                this.plainMessageProcessors.execute(command);
            }
        }
        catch (RuntimeException e) {
            this.oneMessagePerAgentLimiter.remove((Object)token);
            throw e;
        }
    }

    private Runnable onMessage(Message message, Integer token) {
        return () -> {
            try {
                this.messageListener.onMessage(message);
            }
            finally {
                this.oneMessagePerAgentLimiter.remove((Object)token);
            }
        };
    }

    public void setMaxConcurrentMessages(int maxConcurrentMessages) {
        this.maxConcurrentMessages = maxConcurrentMessages;
    }

    public void setMaxConcurrentExpensiveMessages(int maxConcurrentExpensiveMessages) {
        this.maxConcurrentExpensiveMessages = maxConcurrentExpensiveMessages;
    }

    public void setMaxQueuedExpensiveMessages(int maxQueuedExpensiveMessages) {
        this.maxQueuedExpensiveMessages = maxQueuedExpensiveMessages;
    }
}

