/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.docker;

import com.atlassian.bamboo.docker.DataVolume;
import com.atlassian.bamboo.docker.DockerContainerService;
import com.atlassian.bamboo.docker.DockerContainerServiceImpl;
import com.atlassian.bamboo.docker.DockerException;
import com.atlassian.bamboo.docker.RunConfig;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessContext;
import com.atlassian.bamboo.process.ProcessContextFactory;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.setup.HomeDirectoryLayout;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.util.BambooIOUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.SecureTemporaryFiles;
import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.docker.DockerContainerController;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.utils.process.ExternalProcess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DockerContainerControllerImpl
implements DockerContainerController {
    public static final String DOCKER_CAPABILITY = "system.docker.executable";
    private static final String GIT_CACHE_DIRECTORY = "_git-repositories-cache";
    private static final String HG_CACHE_DIRECTORY = "_hg-repositories-cache";
    public static final int CANT_CD_TO_DIRECTORY = 42;
    private final CommonContext commonContext;
    private final DockerContainerService dockerContainerService;
    private final ProcessContext processContext;
    private final CapabilityContext capabilityContext;
    private final CustomVariableContext customVariableContext;
    private final ProcessService processService;
    private final HomeDirectoryLayout homeDirectoryLayout;

    protected DockerContainerControllerImpl(@NotNull CommonContext context, @NotNull DockerContainerService dockerContainerService, @NotNull ProcessContextFactory processContextFactory, @NotNull CapabilityContext capabilityContext, @NotNull CustomVariableContext customVariableContext, @NotNull ProcessService processService, @NotNull HomeDirectoryLayout homeDirectoryLayout) {
        this.commonContext = context;
        this.dockerContainerService = dockerContainerService;
        this.processContext = processContextFactory.forCommonContext(context);
        this.capabilityContext = capabilityContext;
        this.customVariableContext = customVariableContext;
        this.processService = processService;
        this.homeDirectoryLayout = homeDirectoryLayout;
    }

    public void startContainerIfRequired() throws DockerException {
        if (!this.commonContext.getDockerPipelineConfiguration().isEnabled()) {
            return;
        }
        String imageName = this.customVariableContext.substituteString(this.commonContext.getDockerPipelineConfiguration().getImage());
        String dockerCapability = this.capabilityContext.getCapabilityValue(DOCKER_CAPABILITY);
        if (StringUtils.isBlank((CharSequence)dockerCapability)) {
            throw new DockerException("Cannot start docker container, docker capability not defined");
        }
        List volumeList = this.commonContext.getDockerPipelineConfiguration().getDataVolumes().stream().map(dv -> new DataVolume(this.customVariableContext.substituteString(dv.getHostDirectory()), this.customVariableContext.substituteString(dv.getContainerDirectory()))).collect(Collectors.toList());
        List additionalArgs = this.commonContext.getDockerPipelineConfiguration().getAdditionalArgs().stream().map(arg_0 -> ((CustomVariableContext)this.customVariableContext).substituteString(arg_0)).collect(Collectors.toList());
        String containerName = this.commonContext.getBuildKey().getKey() + this.commonContext.getEntityId();
        Path dockerPath = Paths.get(dockerCapability, new String[0]);
        RunConfig runConfig = RunConfig.builder().detach(true).containerName(containerName).command("tail -f /dev/null").volumes(volumeList).tokenizedAdditionalArgs(additionalArgs).useInitialisingScript(true).build();
        try {
            this.dockerContainerService.run(this.processContext, dockerPath, imageName, runConfig, BuildContextHelper.getBuildWorkingDirectory((CommonContext)this.commonContext).toPath(), Collections.emptyMap());
        }
        catch (DockerException e) {
            this.processContext.getBuildLogger().addErrorLogEntry("Failed to start docker container " + containerName, (Throwable)e);
            this.removeContainer(containerName);
            throw e;
        }
        this.commonContext.getVariableContext().addLocalVariable("auto.docker.container.name", containerName);
    }

    public void close() {
        VariableDefinitionContext containerNameVar = (VariableDefinitionContext)this.commonContext.getVariableContext().getEffectiveVariables().get("auto.docker.container.name");
        this.commonContext.getVariableContext().removeLocalVariable("auto.docker.container.name");
        if (containerNameVar != null) {
            this.clearWorkingDirectory(containerNameVar.getValue());
            this.removeContainer(containerNameVar.getValue());
        }
    }

    private void clearWorkingDirectory(String containerName) {
        try {
            BuildContext buildContext = (BuildContext)Narrow.downTo((Object)this.commonContext, BuildContext.class);
            if (buildContext == null || !buildContext.getBuildDefinition().isCleanWorkingDirectory().booleanValue()) {
                return;
            }
            String scriptName = "cleanDirectory.sh";
            try (BambooFiles.QuietlyRemoved temporaryFile = BambooFiles.quietlyRemoved((Path)this.createTemporaryFile("cleanDirectory.sh"));){
                BambooIOUtils.copy((InputStream)DockerContainerServiceImpl.class.getResourceAsStream("cleanDirectory.sh"), (OutputStream)Files.newOutputStream(temporaryFile.getPath(), new OpenOption[0]));
                File buildWorkingDirectory = BuildContextHelper.getBuildWorkingDirectory((CommonContext)this.commonContext);
                ExternalProcess externalProcess = this.processService.executeExternalProcess(this.processContext, new ExternalProcessBuilder().dockerContainerId(containerName).workingDirectory(buildWorkingDirectory).command(Arrays.asList(temporaryFile.getPath().toString(), buildWorkingDirectory.getAbsolutePath())));
                int exitCode = externalProcess.getHandler().getExitCode();
                if (exitCode == 42) {
                    throw new TaskException("Unable to access agent's working directory [" + buildWorkingDirectory + "] from within the container");
                }
            }
        }
        catch (Exception e) {
            this.processContext.getBuildLogger().addErrorLogEntry("Failed to clean working directory from within the container " + containerName, (Throwable)e);
        }
    }

    private void removeContainer(String containerName) {
        Path dockerPath = Paths.get(this.capabilityContext.getCapabilityValue(DOCKER_CAPABILITY), new String[0]);
        try {
            this.dockerContainerService.remove(this.processContext, dockerPath, containerName, BuildContextHelper.getBuildWorkingDirectory((CommonContext)this.commonContext).toPath(), Collections.emptyMap());
        }
        catch (DockerException e) {
            this.processContext.getBuildLogger().addErrorLogEntry("Failed to remove docker container " + containerName, (Throwable)e);
        }
    }

    private Path createTemporaryFile(String name) {
        SecureTemporaryFiles.FileSpecBuilder builder = SecureTemporaryFiles.builder().setDir(this.homeDirectoryLayout.getTempDirectory()).setPrefix(name).setExecutable(true);
        try {
            return SecureTemporaryFiles.createPath((SecureTemporaryFiles.TemporaryFileSpec)builder.build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

