/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages;

import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class ArchiveEntryUtils {
    public static TarArchiveEntry createArchiveEntry(Path path, String fileName) throws IOException {
        TarArchiveEntry entry = ArchiveEntryUtils.createArchiveEntryInternal(path, fileName);
        if (entry.isFile() && Files.isExecutable(path)) {
            entry.setMode(33252);
        }
        return entry;
    }

    public static void setFileProperties(ArchiveEntry entry, Path file) throws IOException {
        if (ArchiveEntryUtils.isExecutable(entry)) {
            BambooFiles.setExecutable((Path)file, (boolean)true);
        }
        try {
            Files.setLastModifiedTime(file, FileTime.fromMillis(entry.getLastModifiedDate().getTime()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isExecutable(ArchiveEntry entry) {
        TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)Narrow.downTo((Object)entry, TarArchiveEntry.class);
        if (tarArchiveEntry == null) {
            return false;
        }
        return (tarArchiveEntry.getMode() & 0x40) != 0;
    }

    private static TarArchiveEntry createArchiveEntryInternal(Path inputFile, String entryName) throws IOException {
        TarArchiveEntry tarArchiveEntry;
        if (Files.isDirectory(inputFile, new LinkOption[0])) {
            tarArchiveEntry = new TarArchiveEntry(entryName, 53);
            tarArchiveEntry.setMode(16877);
            String normalizedName = tarArchiveEntry.getName();
            if (!normalizedName.endsWith("/")) {
                tarArchiveEntry.setName(normalizedName + "/");
            }
        } else {
            tarArchiveEntry = new TarArchiveEntry(entryName, 48);
            tarArchiveEntry.setMode(33188);
            tarArchiveEntry.setSize(Files.size(inputFile));
        }
        tarArchiveEntry.setModTime(Files.getLastModifiedTime(inputFile, new LinkOption[0]).toMillis());
        tarArchiveEntry.setUserName("");
        return tarArchiveEntry;
    }
}

