/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages;

import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResult;
import com.atlassian.bamboo.build.artifact.ArtifactHandlerPublishingResultImpl;
import com.atlassian.bamboo.event.artifact.BuildResultArtifactEvent;
import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.agent.messages.ArchiveEntryUtils;
import com.atlassian.bamboo.v2.build.agent.messages.ArtifactUnpackResult;
import com.atlassian.event.api.EventPublisher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jetbrains.annotations.NotNull;

public class ArtifactStreams {
    public static final Duration TOO_LONG_PROCESSING_DURATION = Duration.ofSeconds(25L);
    private static final Logger log = Logger.getLogger(ArtifactStreams.class);
    private static final int COMPRESSION_LEVEL = -1;
    private static final int BUF_SIZE = (int)SystemProperty.ARTIFACT_COMPRESSION_BUFFER_SIZE.getTypedValue();
    private static final String TIMING_POINT_PREFIX = "XYZBambooArtifactProcessingTimingPointXYZ.";
    private static final String TIMING_POINT_END = "end";
    private static final String TIMING_POINT_START = "start";

    @NotNull
    public static ArtifactUnpackResult deserialiseStreamToDir(InputStream in, Path destination, EventPublisher eventPublisher) throws IOException {
        ArchiveEntry entry;
        LocalDateTime unpackingStart = LocalDateTime.now();
        TarArchiveInputStream archiveInputStream = new TarArchiveInputStream((InputStream)new InflaterInputStream(in, new Inflater(), BUF_SIZE));
        log.debug((Object)("Unpacking artifact to " + destination));
        Path firstFile = null;
        int fileCnt = 0;
        long archiveSize = 0L;
        AtomicReference<Date> archiveCreationStart = new AtomicReference<Date>();
        AtomicReference<Date> archiveCreationEnd = new AtomicReference<Date>();
        byte[] buffer = IOUtils.byteArray((int)((int)SystemProperty.ARTIFACT_COPY_BUFFER_SIZE.getTypedValue()));
        while ((entry = archiveInputStream.getNextEntry()) != null) {
            if (ArtifactStreams.isTimingPoint(entry)) {
                ArtifactStreams.processTimingPoint(entry, archiveCreationStart, archiveCreationEnd);
                continue;
            }
            Path path = BambooFiles.resolvePathUnderParent((Path)destination, (String)entry.getName());
            if (entry.isDirectory()) {
                Files.createDirectories(path, new FileAttribute[0]);
                continue;
            }
            if (fileCnt == 0) {
                firstFile = path;
            }
            ++fileCnt;
            log.debug((Object)("Writing file " + path));
            OutputStream fileOutputStream = BambooPathUtils.openOutputStream((Path)path);
            try {
                ArchiveEntryUtils.setFileProperties(entry, path);
                archiveSize += IOUtils.copyLarge((InputStream)archiveInputStream, (OutputStream)fileOutputStream, (byte[])buffer);
            }
            finally {
                if (fileOutputStream == null) continue;
                fileOutputStream.close();
            }
        }
        ArtifactUnpackResult artifactUnpackResult = new ArtifactUnpackResult(fileCnt, firstFile, (Date)archiveCreationStart.get(), archiveCreationEnd.get(), unpackingStart, LocalDateTime.now());
        log.debug((Object)("Artifact unpacked to " + destination + ", packing took " + artifactUnpackResult.getPackingTime().getSeconds() + "s, unpacking took " + artifactUnpackResult.getUnpackingTime().getSeconds() + "s"));
        if (eventPublisher != null) {
            eventPublisher.publish((Object)new BuildResultArtifactEvent(archiveSize));
        }
        return artifactUnpackResult;
    }

    private static void processTimingPoint(ArchiveEntry entry, AtomicReference<Date> start, AtomicReference<Date> end) {
        String name = entry.getName();
        if (name.endsWith(TIMING_POINT_START)) {
            start.set(entry.getLastModifiedDate());
        } else if (name.endsWith(TIMING_POINT_END)) {
            end.set(entry.getLastModifiedDate());
        } else {
            throw new IllegalArgumentException("Unknown timing point " + entry.getName());
        }
    }

    private static boolean isTimingPoint(ArchiveEntry entry) {
        return entry.getName().startsWith(TIMING_POINT_PREFIX);
    }

    public static ArtifactHandlerPublishingResult writeFileSetToStream(FileSet fileSet, OutputStream out, boolean compression) throws IOException {
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner();
        File rootDir = fileSet.getDir();
        return ArtifactStreams.writeFilesToStream(rootDir.toPath(), Arrays.stream(directoryScanner.getIncludedFiles()), out, compression);
    }

    public static ArtifactHandlerPublishingResult writeFilesToStream(Path rootDir, Stream<String> filesStream, OutputStream out, boolean httpCompressionOn) throws IOException {
        int compressionLevel = httpCompressionOn ? -1 : 0;
        DeflaterOutputStream compressingStream = new DeflaterOutputStream(out, new Deflater(compressionLevel), BUF_SIZE);
        TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream((OutputStream)compressingStream);
        archiveOutputStream.setLongFileMode(3);
        archiveOutputStream.setBigNumberMode(2);
        ArtifactStreams.addTimingPointEntry(archiveOutputStream, TIMING_POINT_START);
        int totalFiles = 0;
        long totalSize = 0L;
        AtomicLong totalWritten = new AtomicLong();
        Iterator files = filesStream.iterator();
        while (files.hasNext()) {
            ++totalFiles;
            String fileName = (String)files.next();
            log.debug((Object)("Transferring artifact file: " + fileName));
            Path path = rootDir.resolve(fileName);
            if (Files.isDirectory(path, new LinkOption[0])) {
                TarArchiveEntry dirEntry = ArchiveEntryUtils.createArchiveEntry(path, fileName);
                archiveOutputStream.putArchiveEntry(dirEntry);
            } else if (Files.isRegularFile(path, new LinkOption[0])) {
                totalSize += Files.size(path);
                try (InputStream fileInputStream = Files.newInputStream(path, new OpenOption[0]);){
                    TarArchiveEntry entry = ArchiveEntryUtils.createArchiveEntry(path, fileName);
                    archiveOutputStream.putArchiveEntry(entry);
                    ArtifactStreams.copyLarge(fileInputStream, (OutputStream)archiveOutputStream, totalWritten);
                }
                catch (Exception e) {
                    log.warn((Object)("Error during artifact transfer, total bytes written: " + totalWritten.get() + ", total requested: " + totalSize + ", latest request: " + Files.size(path)), (Throwable)e);
                    throw e;
                }
            }
            archiveOutputStream.closeArchiveEntry();
        }
        ArtifactStreams.addTimingPointEntry(archiveOutputStream, TIMING_POINT_END);
        archiveOutputStream.finish();
        archiveOutputStream.flush();
        compressingStream.finish();
        compressingStream.flush();
        return ArtifactHandlerPublishingResultImpl.success((Integer)totalFiles, (Long)totalSize);
    }

    private static void addTimingPointEntry(TarArchiveOutputStream archiveOutputStream, String type) throws IOException {
        TarArchiveEntry name = new TarArchiveEntry(TIMING_POINT_PREFIX + type);
        name.setModTime(new Date());
        archiveOutputStream.putArchiveEntry(name);
        archiveOutputStream.closeArchiveEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyLarge(InputStream input, OutputStream output, AtomicLong totalWritten) throws IOException {
        long count = 0L;
        try {
            int n;
            byte[] buffer = new byte[BUF_SIZE];
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            long l = count;
            return l;
        }
        finally {
            totalWritten.getAndAdd(count);
        }
    }

    @NotNull
    public static Stream<String> iterateFilesAndDirs(Path rootDir) throws IOException {
        return Files.walk(rootDir, new FileVisitOption[0]).filter(path -> !path.equals(rootDir)).map(path -> rootDir.relativize((Path)path).toString());
    }
}

