/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages;

import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactUnpackResult {
    private final Path firstFileIfOnlyFile;
    private final LocalDateTime packingStart;
    private final LocalDateTime packingEnd;
    private final LocalDateTime unpackingStart;
    private final LocalDateTime unpackingEnd;

    public ArtifactUnpackResult(int fileCnt, @Nullable Path firstFileIfOnlyFile, Date packingStart, Date packingEnd, LocalDateTime unpackingStart, LocalDateTime unpackingEnd) {
        this.firstFileIfOnlyFile = fileCnt == 1 ? firstFileIfOnlyFile : null;
        this.packingStart = this.toLocalDateTime(packingStart);
        this.packingEnd = this.toLocalDateTime(packingEnd);
        this.unpackingStart = unpackingStart;
        this.unpackingEnd = unpackingEnd;
    }

    @NotNull
    private LocalDateTime toLocalDateTime(Date packingStart) {
        return LocalDateTime.ofInstant(packingStart.toInstant(), ZoneId.systemDefault());
    }

    @Nullable
    public Path getFirstFileIfOnlyFile() {
        return this.firstFileIfOnlyFile;
    }

    public Duration getPackingTime() {
        return Duration.between(this.packingStart, this.packingEnd);
    }

    public Duration getUnpackingTime() {
        return Duration.between(this.unpackingStart, this.unpackingEnd);
    }
}

