/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages;

import com.atlassian.bamboo.collections.message.FinalLinkedList;
import com.atlassian.bamboo.v2.build.agent.messages.BambooAgentMessage;
import com.atlassian.bamboo.v2.build.agent.messages.BambooAgentMessageBatch;
import com.atlassian.bamboo.v2.build.agent.messages.ExpensiveMessage;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BatchRemoteBambooMessage
implements BambooAgentMessageBatch<BambooAgentMessage> {
    private static final Logger log = Logger.getLogger(BatchRemoteBambooMessage.class);
    private final FinalLinkedList<BambooAgentMessage> messages = new FinalLinkedList();
    private int size;
    private transient boolean isExpensive;
    private transient boolean sendDuringHeartAttack;

    private BatchRemoteBambooMessage() {
    }

    @Override
    public void add(@NotNull BambooAgentMessage bambooAgentMessage) {
        this.isExpensive |= bambooAgentMessage.getClass().isAnnotationPresent(ExpensiveMessage.class);
        this.sendDuringHeartAttack |= bambooAgentMessage.shouldBeSentDuringHeartAttack();
        this.messages.add((Object)bambooAgentMessage);
        ++this.size;
    }

    @Override
    public Object deliver() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delivering " + this.size + " messages."));
        }
        for (BambooAgentMessage message : this.messages) {
            message.deliver();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delivered " + this.size + " messages."));
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean shouldStartNewBatch(@NotNull BambooAgentMessage bambooAgentMessage) {
        return false;
    }

    @Override
    public boolean isExpensive() {
        return this.isExpensive;
    }

    @Override
    public boolean shouldBeSentDuringHeartAttack() {
        return this.sendDuringHeartAttack;
    }

    public String toString() {
        return BatchRemoteBambooMessage.summarize(this.messages);
    }

    static String summarize(List<?> list) {
        StringBuilder sb = new StringBuilder();
        int count = 1;
        if (list.isEmpty()) {
            sb.append("[]");
        } else {
            Class<?> previousClass = list.get(0).getClass();
            for (int i = 1; i <= list.size(); ++i) {
                Class<?> currentClass;
                Class<?> clazz = currentClass = i < list.size() ? list.get(i).getClass() : null;
                if (previousClass != currentClass) {
                    sb.append(count).append("x").append(previousClass.getName()).append(" ");
                    count = 0;
                    previousClass = currentClass;
                }
                ++count;
            }
        }
        return sb.toString();
    }

    public static BambooAgentMessageBatch.BatchFactory descriptor() {
        return new BambooAgentMessageBatch.BatchFactory(){

            @Override
            public boolean canBatch(@NotNull BambooAgentMessage bambooAgentMessage) {
                return true;
            }

            @Override
            public Class<? extends BambooAgentMessageBatch> getBatchClass() {
                return BatchRemoteBambooMessage.class;
            }

            @Override
            public BambooAgentMessageBatch newBatch() {
                return new BatchRemoteBambooMessage();
            }
        };
    }
}

