/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.execution.ExecutionPhaseService;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.messages.AbstractBambooAgentMessage;
import com.atlassian.bamboo.v2.build.agent.messages.RemoteBambooMessage;
import com.atlassian.spring.container.ContainerManager;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CancelExecutionAgentMessage
extends AbstractBambooAgentMessage
implements RemoteBambooMessage {
    private static final Logger log = Logger.getLogger(CancelExecutionAgentMessage.class);
    private final ResultKey resultKey;
    @Nullable
    private final Long deploymentResultId;

    public CancelExecutionAgentMessage(ResultKey resultKey, @Nullable Long deploymentResultId) {
        this.resultKey = resultKey;
        this.deploymentResultId = deploymentResultId;
    }

    @Override
    public Object deliver() {
        ExecutableBuildAgent executableBuildAgent = (ExecutableBuildAgent)ContainerManager.getComponent((String)"executableBuildAgent");
        ExecutionPhaseService executionPhaseService = (ExecutionPhaseService)ComponentAccessor.EXECUTION_PHASE_SERVICE.get();
        boolean buildActuallyCancelled = executableBuildAgent.cancelBuild(this.resultKey.getKey());
        executionPhaseService.executionCancelled(this.resultKey, buildActuallyCancelled);
        return null;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.resultKey).append((Object)this.deploymentResultId).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CancelExecutionAgentMessage)) {
            return false;
        }
        CancelExecutionAgentMessage rhs = (CancelExecutionAgentMessage)o;
        return new EqualsBuilder().append((Object)this.resultKey, (Object)rhs.resultKey).append((Object)this.deploymentResultId, (Object)rhs.deploymentResultId).isEquals();
    }

    public int compareTo(Object obj) {
        CancelExecutionAgentMessage o = (CancelExecutionAgentMessage)obj;
        return new CompareToBuilder().append((Object)this.resultKey, (Object)o.resultKey).append((Object)this.deploymentResultId, (Object)o.deploymentResultId).toComparison();
    }
}

