/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages;

import com.atlassian.bamboo.shell.ShellSession;
import com.atlassian.bamboo.shell.ShellSessionManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.v2.build.agent.messages.RemoteBambooMessage;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ExecuteCommandMessage
implements RemoteBambooMessage {
    private static final Logger log = Logger.getLogger(ExecuteCommandMessage.class);
    private final String command;
    private final long sessionId;
    private static final Supplier<ShellSessionManager> shellSessionManager = ComponentAccessor.newLazyComponentReference((String)"shellSessionManager");

    public ExecuteCommandMessage(String command, long sessionId) {
        this.command = command;
        this.sessionId = sessionId;
    }

    @Override
    @Nullable
    public Object deliver() {
        ShellSession session = shellSessionManager.get().getSession(this.sessionId);
        try {
            session.execute(this.command);
        }
        catch (Exception e) {
            log.info((Object)("Error when executing [" + this.command + "], removing session. Exception:"), (Throwable)e);
            shellSessionManager.get().removeSession(this.sessionId);
        }
        return null;
    }
}

