/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.logger.LoggerId;
import com.atlassian.bamboo.collections.message.FinalLinkedList;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.LogMessageBatchConverter;
import com.atlassian.bamboo.v2.build.agent.messages.AbstractAddLogEntry;
import com.atlassian.bamboo.v2.build.agent.messages.BambooAgentMessage;
import com.atlassian.bamboo.v2.build.agent.messages.BambooAgentMessageBatch;
import com.atlassian.bamboo.v2.build.agent.messages.LogMessageStream;
import com.atlassian.bamboo.v2.build.queue.SelfSerialisingMessage;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogMessageBatch
implements BambooAgentMessageBatch<AbstractAddLogEntry>,
SelfSerialisingMessage {
    private static final Logger log = Logger.getLogger(LogMessageBatch.class);
    private volatile FinalLinkedList<AbstractAddLogEntry> messages = new FinalLinkedList();
    private volatile int size = 0;
    private LoggerId<? extends Key> loggerId;
    private Boolean needToPersistOnTarget;

    @Override
    @Nullable
    public Object deliver() {
        throw new UnsupportedOperationException("This message is not supposed to be delivered. See " + LogMessageStream.class);
    }

    @Override
    public void add(@NotNull AbstractAddLogEntry abstractAddLogEntry) {
        if (this.loggerId == null) {
            this.loggerId = abstractAddLogEntry.getLoggerId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting loggerId to " + this.loggerId + " for " + BambooObjectUtils.getId((Object)this)));
            }
        }
        if (this.needToPersistOnTarget == null) {
            this.needToPersistOnTarget = abstractAddLogEntry.isNeedToPersistOnTarget();
            log.debug((Object)("Will persist on target is " + this.needToPersistOnTarget));
        }
        Preconditions.checkState((this.messages != null ? 1 : 0) != 0, (Object)"trying to access a drained message batch");
        this.messages.add((Object)abstractAddLogEntry);
        ++this.size;
    }

    @Nullable
    public LoggerId<? extends Key> getLoggerId() {
        return this.loggerId;
    }

    @Nullable
    public Boolean getNeedToPersistOnTarget() {
        return this.needToPersistOnTarget;
    }

    @NotNull
    public Queue<AbstractAddLogEntry> drainMessages() {
        Preconditions.checkState((this.messages != null ? 1 : 0) != 0, (Object)"trying to access a drained message batch");
        FinalLinkedList<AbstractAddLogEntry> drainedMessages = this.messages;
        this.messages = null;
        return drainedMessages;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean shouldStartNewBatch(@NotNull BambooAgentMessage bambooAgentMessage) {
        AbstractAddLogEntry addLogEntryMessage = (AbstractAddLogEntry)bambooAgentMessage;
        LoggerId<? extends Serializable> newLoggerId = addLogEntryMessage.getLoggerId();
        boolean loggerEquals = newLoggerId.equals(this.loggerId);
        if (!loggerEquals) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("newLoggerId: " + newLoggerId + " is different to: " + this.loggerId));
            }
            return true;
        }
        if (!Boolean.TRUE.equals(this.needToPersistOnTarget) && addLogEntryMessage.isNeedToPersistOnTarget()) {
            log.debug((Object)"Batch is not persistent but there's a message that required persisting");
            return true;
        }
        return false;
    }

    @Override
    public boolean isExpensive() {
        return false;
    }

    public static BambooAgentMessageBatch.BatchFactory descriptor() {
        return new BambooAgentMessageBatch.BatchFactory(){

            @Override
            public boolean canBatch(@NotNull BambooAgentMessage bambooAgentMessage) {
                AbstractAddLogEntry abstractAddLogEntry = (AbstractAddLogEntry)Narrow.downTo((Object)bambooAgentMessage, AbstractAddLogEntry.class);
                if (abstractAddLogEntry == null) {
                    return false;
                }
                return LogMessageBatchConverter.getDestinationId(abstractAddLogEntry) != null;
            }

            @Override
            public Class<? extends BambooAgentMessageBatch> getBatchClass() {
                return LogMessageBatch.class;
            }

            @Override
            public BambooAgentMessageBatch newBatch() {
                return new LogMessageBatch();
            }
        };
    }

    public int getDeserialiserId() {
        return 0;
    }

    public String toString() {
        return BambooObjectUtils.getId((Object)this) + " for " + this.loggerId;
    }
}

