/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.ServerBuildLoggerManager;
import com.atlassian.bamboo.build.logger.FileWritingBuildLogger;
import com.atlassian.bamboo.build.logger.LoggerId;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.v2.build.agent.LogMessageBatchConverter;
import com.atlassian.bamboo.v2.build.agent.messages.AbstractAddLogEntry;
import com.atlassian.bamboo.v2.build.agent.messages.AddBuildLogEntry;
import com.atlassian.bamboo.v2.build.agent.messages.BambooAgentMessage;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class LogMessageStream
implements BambooAgentMessage {
    private static final Logger log = Logger.getLogger(LogMessageStream.class);
    private final transient BytesMessage jmsMessage;

    public LogMessageStream(BytesMessage message) {
        this.jmsMessage = message;
    }

    @Override
    @Nullable
    public Object deliver() {
        try {
            int messageCount = LogMessageBatchConverter.readMessageCount(this.jmsMessage);
            LoggerId<? extends Key> loggerId = LogMessageBatchConverter.readLoggerId(this.jmsMessage);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Delivering " + messageCount + " log messages for " + loggerId.getKey() + ", total message size: " + this.jmsMessage.getBodyLength()));
            }
            ServerBuildLoggerManager buildLoggerManager = (ServerBuildLoggerManager)ComponentAccessor.BUILD_LOGGER_MANAGER.get();
            FileWritingBuildLogger buildLogger = buildLoggerManager.getFileWritingLogger(loggerId);
            while (messageCount-- > 0) {
                AbstractAddLogEntry logEntry = LogMessageBatchConverter.readLogEntry(loggerId, this.jmsMessage);
                if (logEntry instanceof AddBuildLogEntry) {
                    buildLogger.addRemoteBuildLogEntry(logEntry.getLogEntry(), logEntry.isNeedToPersistOnTarget(), logEntry.isAddedAfterLogSpoolClosed());
                    continue;
                }
                buildLogger.addRemoteErrorLogEntry(logEntry.getLogEntry(), logEntry.isNeedToPersistOnTarget(), logEntry.isAddedAfterLogSpoolClosed());
            }
        }
        catch (JMSException e) {
            log.warn((Object)"", (Throwable)e);
        }
        return null;
    }
}

