/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.process.ProcessManagement;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.messages.AbstractBambooAgentMessage;
import com.atlassian.bamboo.v2.build.agent.messages.RemoteBambooMessage;
import com.atlassian.spring.container.ContainerManager;
import java.lang.management.ManagementFactory;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ManageHungBuildMessage
extends AbstractBambooAgentMessage
implements RemoteBambooMessage {
    private static final Logger log = Logger.getLogger(ManageHungBuildMessage.class);
    private PlanResultKey planResultKey;

    public ManageHungBuildMessage(PlanResultKey planResultKey) {
        this.planResultKey = planResultKey;
    }

    @Override
    public Object deliver() {
        BuildLoggerManager buildLoggerManager = (BuildLoggerManager)ContainerManager.getComponent((String)"buildLoggerManager");
        ExecutableBuildAgent executableBuildAgent = (ExecutableBuildAgent)ContainerManager.getComponent((String)"executableBuildAgent");
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        log.info((Object)("Captured runtimeMxBean: " + pid));
        int npid = Integer.parseInt(pid.split("@")[0]);
        log.info((Object)("Captured pid is: " + npid));
        this.manageProcesses(npid, this.planResultKey == null ? null : buildLoggerManager.getLogger((ResultKey)this.planResultKey), executableBuildAgent);
        return npid;
    }

    private void manageProcesses(int pid, BuildLogger buildLogger, ExecutableBuildAgent executableBuildAgent) {
        try {
            if (executableBuildAgent != null) {
                executableBuildAgent.executeWithCurrentContext(() -> {
                    CommonContext building = executableBuildAgent.getBuilding();
                    if (building != null && !building.getResultKey().equals(this.planResultKey)) {
                        log.info((Object)"Not stopping child processes as build agent has moved to another build");
                        return null;
                    }
                    ProcessManagement.getInstance(buildLogger).getStackTraceAndKillRelatedProcesses(pid);
                    this.stopBuild(this.planResultKey, executableBuildAgent);
                    return null;
                });
            } else {
                log.warn((Object)"executableBuildAgent is null...executableBuildAgent  is used to make sure that a hung build always finish (which is true in 99% of the cases)");
            }
        }
        catch (Exception e) {
            log.error((Object)"Errors interacting with ProcessManagement object", (Throwable)e);
        }
    }

    private void stopBuild(PlanResultKey planResultKey, @NotNull ExecutableBuildAgent executableBuildAgent) {
        try {
            log.info((Object)"stopping the build (just in case it doesn't finish...)");
            executableBuildAgent.cancelBuild(planResultKey.toString());
        }
        catch (Exception e) {
            log.warn((Object)"Exception while sending the stop message, but nothing to be worried about. This is just a complimentary function to ensure a hung build always finish (which is true in 99% of the cases)");
        }
    }
}

