/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages.toserver;

import com.atlassian.bamboo.analytics.agent.RemoteAgentsAnalyticsService;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.analytics.JavaVersion;
import com.atlassian.bamboo.utils.analytics.OsType;
import com.atlassian.bamboo.v2.build.agent.messages.AbstractBambooAgentMessage;
import org.jetbrains.annotations.Nullable;

public class AgentAnalyticsMessage
extends AbstractBambooAgentMessage {
    private final long agentId;
    private final OsType agentOs;
    private final JavaVersion agentJavaVersion;

    public AgentAnalyticsMessage(long agentId) {
        this.agentId = agentId;
        this.agentOs = OsType.getCurrentOs();
        this.agentJavaVersion = JavaVersion.getCurrentJavaVersion();
    }

    @Override
    @Nullable
    public Object deliver() {
        RemoteAgentsAnalyticsService remoteAgentsAnalyticsService = (RemoteAgentsAnalyticsService)ComponentAccessor.REMOTE_AGENTS_OS_USAGE_ANALYTICS_SERVICE.get();
        remoteAgentsAnalyticsService.recordOsUsageByAgent(this.agentId, this.agentOs);
        remoteAgentsAnalyticsService.recordJavaVersionUsageByAgent(this.agentId, this.agentJavaVersion);
        return null;
    }
}

