/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.messages.toserver;

import com.atlassian.bamboo.event.sse.ServerSentEvent;
import com.atlassian.bamboo.event.sse.ServerSentEventQueue;
import com.atlassian.bamboo.util.HtmlUtils;
import com.atlassian.bamboo.v2.build.agent.messages.AbstractBambooAgentMessage;
import com.atlassian.bamboo.v2.build.agent.messages.BambooAgentMessage;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ShellProcessLogMessage
extends AbstractBambooAgentMessage {
    private static final Logger log = Logger.getLogger(ShellProcessLogMessage.class);
    private final long sessionId;
    private final StreamType streamType;
    private final String data;

    public ShellProcessLogMessage(long sessionId, StreamType streamType, String data) {
        this.sessionId = sessionId;
        this.streamType = streamType;
        this.data = data;
    }

    @Override
    @Nullable
    public Object deliver() {
        BlockingQueue queue = ServerSentEventQueue.getQueue((long)this.sessionId);
        return queue.add(new ServerSentEvent(this.streamType.toString(), HtmlUtils.colorizeAnsiToHtml((String)StringEscapeUtils.unescapeHtml4((String)this.data))));
    }

    public static BambooAgentMessage stdErr(long sessionId, String input) {
        return new ShellProcessLogMessage(sessionId, StreamType.STDERR, input);
    }

    public static BambooAgentMessage stdOut(long sessionId, String input) {
        return new ShellProcessLogMessage(sessionId, StreamType.STDOUT, input);
    }

    private static enum StreamType {
        STDOUT,
        STDERR;

    }
}

