/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.aws;

import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.AWSManager;
import com.atlassian.aws.credentials.AWSCredentials;
import com.atlassian.aws.credentials.EC2ProfileCredentials;
import com.atlassian.aws.credentials.StaticAWSCredentials;
import com.atlassian.aws.ec2.SpotPrices;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.server.AwsCredentialsType;
import com.atlassian.bamboo.agent.elastic.server.ElasticAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.event.ElasticConfigUpdatedEvent;
import com.atlassian.event.api.EventListener;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class AwsAccountBeanImpl
implements AwsAccountBean {
    private static final Logger log = Logger.getLogger(AwsAccountBeanImpl.class);
    private static final int MAXIMUM_SPOT_PRICES_AGE_SECONDS = 30;
    private int maximumEbsVolumeStatusAgeSeconds;
    private int maximumInstanceStatusAgeSeconds;
    private int maximumSpotRequestStatusAgeSeconds;
    private final ResettableLazyReference<AWSAccount> awsAccount = new ResettableLazyReference<AWSAccount>(){

        protected AWSAccount create() {
            EC2ProfileCredentials awsCredentials;
            ElasticConfiguration elasticConfiguration = AwsAccountBeanImpl.this.elasticAccountBean.getElasticConfig();
            if (elasticConfiguration == null) {
                throw new IllegalStateException("Could not create AWS account entity, no configuration details were found. Please configure your AWS credentials.");
            }
            log.info((Object)String.format("Initialising AWS account using %s connected to %s", elasticConfiguration.getAwsCredentialsType() == AwsCredentialsType.ACCESS_KEY ? "access key" : "instance profile", elasticConfiguration.getRegion()));
            if (elasticConfiguration.getAwsCredentialsType() == AwsCredentialsType.ACCESS_KEY) {
                String awsSecretKey = AwsAccountBeanImpl.this.secretEncryptionService.decrypt(elasticConfiguration.getAwsSecretKey());
                awsCredentials = new StaticAWSCredentials(elasticConfiguration.getAwsAccessKeyId(), awsSecretKey);
            } else {
                awsCredentials = new EC2ProfileCredentials();
            }
            AWSAccount account = AwsAccountBeanImpl.this.awsManager.getAWSAccount(elasticConfiguration.getRegion(), (AWSCredentials)awsCredentials);
            account.setMaximumEbsVolumeStatusAgeSeconds(AwsAccountBeanImpl.this.maximumEbsVolumeStatusAgeSeconds);
            account.setMaximumInstanceStatusAgeSeconds(AwsAccountBeanImpl.this.maximumInstanceStatusAgeSeconds);
            account.setMaximumSpotRequestStatusAgeSeconds(AwsAccountBeanImpl.this.maximumSpotRequestStatusAgeSeconds);
            return account;
        }
    };
    private final ElasticAccountBean elasticAccountBean;
    private final AWSManager awsManager;
    private final SecretEncryptionService secretEncryptionService;
    private final Supplier<SpotPrices> spotPricesSupplier = () -> {
        SpotPrices currentSpotPrices;
        try {
            currentSpotPrices = this.getAwsAccount().getSpotPrices();
        }
        catch (Exception e) {
            log.warn((Object)"Unable to retrieve spot prices", (Throwable)e);
            currentSpotPrices = new SpotPrices();
        }
        return currentSpotPrices;
    };
    private final Supplier<SpotPrices> spotPrices = Lazy.timeToLive(this.spotPricesSupplier, (long)30L, (TimeUnit)TimeUnit.SECONDS);

    public AwsAccountBeanImpl(ElasticAccountBean elasticAccountBean, AWSManager awsManager, SecretEncryptionService secretEncryptionService) {
        this.elasticAccountBean = elasticAccountBean;
        this.awsManager = awsManager;
        this.secretEncryptionService = secretEncryptionService;
    }

    @NotNull
    public AWSAccount getAwsAccount() {
        return (AWSAccount)this.awsAccount.get();
    }

    @NotNull
    public Map<String, AvailabilityZone> getAvailabilityZones() throws AWSException {
        return ((AWSAccount)this.awsAccount.get()).getAvailabilityZones();
    }

    @Nullable
    public String getAccountDetailsValidationError(AwsSupportConstants.Region region, String awsAccessID, String awsSecretKey) throws AWSException {
        return this.awsManager.getAWSAccount(region, awsAccessID, awsSecretKey).getAccountValidationError();
    }

    @Nullable
    public String getAccountDetailsValidationError(AwsSupportConstants.Region region, AWSCredentials awsCredentials) throws AWSException {
        AWSAccount account = this.awsManager.getAWSAccount(region, awsCredentials);
        return account.getAccountValidationError();
    }

    @EventListener
    public void onElasticConfigUpdatedEvent(ElasticConfigUpdatedEvent event) {
        this.awsAccount.reset();
    }

    @NotNull
    public SpotPrices getCurrentSpotPrices() {
        return this.spotPrices.get();
    }

    public void setMaximumEbsVolumeStatusAgeSeconds(int maximumStatusAge) {
        this.maximumEbsVolumeStatusAgeSeconds = maximumStatusAge;
    }

    public void setMaximumInstanceStatusAgeSeconds(int maximumStatusAge) {
        this.maximumInstanceStatusAgeSeconds = maximumStatusAge;
    }

    public void setMaximumSpotRequestStatusAgeSeconds(int maximumStatusAge) {
        this.maximumSpotRequestStatusAgeSeconds = maximumStatusAge;
    }
}

