/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.ec2.EC2Utils;
import com.atlassian.aws.ec2.model.InstanceId;
import com.atlassian.aws.utils.CryptoUtils;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import io.atlassian.fugue.Either;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PEMKeyPair;
import org.jetbrains.annotations.NotNull;

public class Ec2PrivateKeyHandlerImpl {
    private static final Logger log = Logger.getLogger(Ec2PrivateKeyHandlerImpl.class);
    private final AwsAccountBean awsAccountBean;

    public Ec2PrivateKeyHandlerImpl(AwsAccountBean awsAccountBean) {
        this.awsAccountBean = awsAccountBean;
    }

    @NotNull
    public Either<ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus, File> getPrivateKeyLocation() {
        File expectedPrivateKeyLocation = this.getUnvalidatedPrivateKeyLocation();
        ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus validationError = this.getValidationError(expectedPrivateKeyLocation);
        return validationError != ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus.VALIDATION_SUCCESSFUL ? Either.left((Object)validationError) : Either.right((Object)expectedPrivateKeyLocation);
    }

    @NotNull
    private ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus getValidationError(File privateKeyLocation) {
        PEMKeyPair pemKeyPair;
        if (!privateKeyLocation.exists()) {
            return ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus.KEYPAIR_FILE_DOES_NOT_EXIST;
        }
        if (!privateKeyLocation.canRead()) {
            return ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus.KEYPAIR_UNREADABLE;
        }
        try {
            pemKeyPair = CryptoUtils.parsePemKeyPair((File)privateKeyLocation);
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
            return ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus.KEYPAIR_CANNOT_PARSE;
        }
        Either<ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus, byte[]> awsFingerprint = this.getFingerprint();
        if (awsFingerprint.isLeft()) {
            return (ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus)awsFingerprint.left().get();
        }
        try {
            return EC2Utils.isKeyMatching((PEMKeyPair)pemKeyPair, (byte[])((byte[])awsFingerprint.right().get())) ? ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus.VALIDATION_SUCCESSFUL : ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus.KEYPAIR_MISMATCH;
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
            return ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus.KEYPAIR_UNABLE_TO_VALIDATE;
        }
    }

    private Either<ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus, byte[]> getFingerprint() {
        String keyPairName = this.getKeyPairName();
        AWSAccount account = this.awsAccountBean.getAwsAccount();
        Map keyPairs = account.describeEc2KeyPairs(new String[]{keyPairName});
        KeyPairInfo keyPairInfo = (KeyPairInfo)keyPairs.get(keyPairName);
        if (keyPairInfo == null) {
            return Either.left((Object)ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus.KEYPAIR_DOES_NOT_EXIST_ON_ACCOUNT);
        }
        byte[] bytes = EC2Utils.parseFingerprint((String)keyPairInfo.getKeyFingerprint());
        return Either.right((Object)bytes);
    }

    @NotNull
    public Either<ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus, Optional<String>> getPassword(RemoteElasticInstance instance) {
        InstanceId instanceId = InstanceId.from((String)instance.getInstance().getInstanceId());
        Either<ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus, File> privateKeyLocation = this.getPrivateKeyLocation();
        if (privateKeyLocation.isLeft()) {
            return Either.left((Object)((ElasticFunctionalityFacade.Ec2PrivateKeyValidationStatus)privateKeyLocation.left().get()));
        }
        File privateKeyFile = (File)privateKeyLocation.right().get();
        String password = this.awsAccountBean.getAwsAccount().getPassword(privateKeyFile, instanceId);
        return Either.right(Optional.ofNullable(password));
    }

    @NotNull
    private String getKeyPairName() {
        return ElasticInstanceManager.ELASTIC_BAMBOO_KEY_PAIR;
    }

    public File getUnvalidatedPrivateKeyLocation() {
        return FileUtils.getFile((File)SystemDirectory.getSharedHome(), (String[])new String[]{"configuration", ElasticInstanceManager.ELASTIC_BAMBOO_KEY_PAIR_FILE});
    }
}

